/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.get;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.ActionResponse;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.Strings;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public class GetIndexResponse
extends ActionResponse
implements ToXContentObject {
    private ImmutableOpenMap<String, MappingMetadata> mappings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, List<AliasMetadata>> aliases = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, Settings> settings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, Settings> defaultSettings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, String> dataStreams = ImmutableOpenMap.of();
    private final String[] indices;

    public GetIndexResponse(String[] indices, ImmutableOpenMap<String, MappingMetadata> mappings, ImmutableOpenMap<String, List<AliasMetadata>> aliases, ImmutableOpenMap<String, Settings> settings, ImmutableOpenMap<String, Settings> defaultSettings, ImmutableOpenMap<String, String> dataStreams) {
        this.indices = indices;
        Arrays.sort(indices);
        if (mappings != null) {
            this.mappings = mappings;
        }
        if (aliases != null) {
            this.aliases = aliases;
        }
        if (settings != null) {
            this.settings = settings;
        }
        if (defaultSettings != null) {
            this.defaultSettings = defaultSettings;
        }
        if (dataStreams != null) {
            this.dataStreams = dataStreams;
        }
    }

    GetIndexResponse(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        int mappingsSize = in.readVInt();
        ImmutableOpenMap.Builder<String, MappingMetadata> mappingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < mappingsSize; ++i) {
            String index = in.readString();
            if (in.getVersion().before(Version.V_2_0_0)) {
                int numMappings = in.readVInt();
                if (numMappings == 0) {
                    mappingsMapBuilder.put(index, MappingMetadata.EMPTY_MAPPINGS);
                    continue;
                }
                if (numMappings == 1) {
                    String type = in.readString();
                    if (!"_doc".equals(type)) {
                        throw new IllegalStateException("Expected _doc but got [" + type + "]");
                    }
                    mappingsMapBuilder.put(index, new MappingMetadata(in));
                    continue;
                }
                throw new IllegalStateException("Expected 0 or 1 mappings but got: " + numMappings);
            }
            MappingMetadata metadata = in.readOptionalWriteable(MappingMetadata::new);
            mappingsMapBuilder.put(index, metadata != null ? metadata : MappingMetadata.EMPTY_MAPPINGS);
        }
        this.mappings = mappingsMapBuilder.build();
        int aliasesSize = in.readVInt();
        ImmutableOpenMap.Builder aliasesMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < aliasesSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<AliasMetadata> aliasEntryBuilder = new ArrayList<AliasMetadata>(valueSize);
            for (int j = 0; j < valueSize; ++j) {
                aliasEntryBuilder.add(new AliasMetadata(in));
            }
            aliasesMapBuilder.put(key, Collections.unmodifiableList(aliasEntryBuilder));
        }
        this.aliases = aliasesMapBuilder.build();
        int settingsSize = in.readVInt();
        ImmutableOpenMap.Builder<String, Settings> settingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < settingsSize; ++i) {
            String key = in.readString();
            settingsMapBuilder.put(key, Settings.readSettingsFromStream(in));
        }
        this.settings = settingsMapBuilder.build();
        ImmutableOpenMap.Builder<String, Settings> defaultSettingsMapBuilder = ImmutableOpenMap.builder();
        int defaultSettingsSize = in.readVInt();
        for (int i = 0; i < defaultSettingsSize; ++i) {
            defaultSettingsMapBuilder.put(in.readString(), Settings.readSettingsFromStream(in));
        }
        this.defaultSettings = defaultSettingsMapBuilder.build();
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_8_0)) {
            ImmutableOpenMap.Builder<String, String> dataStreamsMapBuilder = ImmutableOpenMap.builder();
            int dataStreamsSize = in.readVInt();
            for (int i = 0; i < dataStreamsSize; ++i) {
                dataStreamsMapBuilder.put(in.readString(), in.readOptionalString());
            }
            this.dataStreams = dataStreamsMapBuilder.build();
        }
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, MappingMetadata> getMappings() {
        return this.mappings();
    }

    public ImmutableOpenMap<String, List<AliasMetadata>> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, List<AliasMetadata>> getAliases() {
        return this.aliases();
    }

    public ImmutableOpenMap<String, Settings> settings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, String> dataStreams() {
        return this.dataStreams;
    }

    public ImmutableOpenMap<String, String> getDataStreams() {
        return this.dataStreams();
    }

    public ImmutableOpenMap<String, Settings> defaultSettings() {
        return this.defaultSettings;
    }

    public ImmutableOpenMap<String, Settings> getSettings() {
        return this.settings();
    }

    public String getSetting(String index, String setting) {
        Settings indexSettings = this.settings.get(index);
        if (setting != null) {
            if (indexSettings != null && indexSettings.hasValue(setting)) {
                return indexSettings.get(setting);
            }
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null) {
                return defaultIndexSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, MappingMetadata> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            if (out.getVersion().before(Version.V_2_0_0)) {
                out.writeVInt(objectObjectCursor.value == MappingMetadata.EMPTY_MAPPINGS ? 0 : 1);
                if (objectObjectCursor.value == MappingMetadata.EMPTY_MAPPINGS) continue;
                out.writeString("_doc");
                ((MappingMetadata)objectObjectCursor.value).writeTo(out);
                continue;
            }
            out.writeOptionalWriteable((Writeable)objectObjectCursor.value);
        }
        out.writeVInt(this.aliases.size());
        for (ObjectObjectCursor<String, Object> objectObjectCursor : this.aliases) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((List)objectObjectCursor.value).size());
            for (AliasMetadata aliasEntry : (List)objectObjectCursor.value) {
                aliasEntry.writeTo(out);
            }
        }
        out.writeVInt(this.settings.size());
        for (ObjectObjectCursor<String, Object> objectObjectCursor : this.settings) {
            out.writeString((String)objectObjectCursor.key);
            Settings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
        }
        out.writeVInt(this.defaultSettings.size());
        for (ObjectObjectCursor<String, Object> objectObjectCursor : this.defaultSettings) {
            out.writeString((String)objectObjectCursor.key);
            Settings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
        }
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_8_0)) {
            out.writeVInt(this.dataStreams.size());
            for (ObjectObjectCursor<String, Object> objectObjectCursor : this.dataStreams) {
                out.writeString((String)objectObjectCursor.key);
                out.writeOptionalString((String)objectObjectCursor.value);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (String index : this.indices) {
            String dataStream;
            builder.startObject(index);
            builder.startObject("aliases");
            List<AliasMetadata> indexAliases = this.aliases.get(index);
            if (indexAliases != null) {
                for (AliasMetadata alias : indexAliases) {
                    AliasMetadata.Builder.toXContent(alias, builder, params);
                }
            }
            builder.endObject();
            MappingMetadata indexMappings = this.mappings.get(index);
            if (indexMappings == null) {
                builder.startObject("mappings").endObject();
            } else {
                builder.field("mappings", indexMappings.sourceAsMap());
            }
            builder.startObject("settings");
            Settings indexSettings = this.settings.get(index);
            if (indexSettings != null) {
                indexSettings.toXContent(builder, params);
            }
            builder.endObject();
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null && !defaultIndexSettings.isEmpty()) {
                builder.startObject("defaults");
                defaultIndexSettings.toXContent(builder, params);
                builder.endObject();
            }
            if ((dataStream = this.dataStreams.get(index)) != null) {
                builder.field("data_stream", dataStream);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetIndexResponse that = (GetIndexResponse)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.settings, that.settings) && Objects.equals(this.defaultSettings, that.defaultSettings) && Objects.equals(this.dataStreams, that.dataStreams);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.aliases, this.mappings, this.settings, this.defaultSettings, this.dataStreams);
    }
}

