/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.recovery;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.action.support.DefaultShardOperationFailedException;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.indices.recovery.RecoveryState;

public class RecoveryResponse
extends BroadcastResponse {
    private final Map<String, List<RecoveryState>> shardRecoveryStates;

    public RecoveryResponse(StreamInput in) throws IOException {
        super(in);
        this.shardRecoveryStates = in.readMapOfLists(StreamInput::readString, RecoveryState::new);
    }

    public RecoveryResponse(int totalShards, int successfulShards, int failedShards, Map<String, List<RecoveryState>> shardRecoveryStates, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardRecoveryStates = shardRecoveryStates;
    }

    public boolean hasRecoveries() {
        return this.shardRecoveryStates.size() > 0;
    }

    public Map<String, List<RecoveryState>> shardRecoveryStates() {
        return this.shardRecoveryStates;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.hasRecoveries()) {
            for (String index : this.shardRecoveryStates.keySet()) {
                List<RecoveryState> recoveryStates = this.shardRecoveryStates.get(index);
                if (recoveryStates == null || recoveryStates.size() == 0) continue;
                builder.startObject(index);
                builder.startArray("shards");
                for (RecoveryState recoveryState : recoveryStates) {
                    builder.startObject();
                    recoveryState.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMapOfLists(this.shardRecoveryStates, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

