/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.replication;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.action.support.DefaultShardOperationFailedException;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.indices.replication.SegmentReplicationState;

public class SegmentReplicationStatsResponse
extends BroadcastResponse {
    private final Map<String, List<SegmentReplicationState>> shardSegmentReplicationStates;

    public SegmentReplicationStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.shardSegmentReplicationStates = in.readMapOfLists(StreamInput::readString, SegmentReplicationState::new);
    }

    public SegmentReplicationStatsResponse(int totalShards, int successfulShards, int failedShards, Map<String, List<SegmentReplicationState>> shardSegmentReplicationStates, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardSegmentReplicationStates = shardSegmentReplicationStates;
    }

    public boolean hasSegmentReplicationStats() {
        return this.shardSegmentReplicationStates.size() > 0;
    }

    public Map<String, List<SegmentReplicationState>> shardSegmentReplicationStates() {
        return this.shardSegmentReplicationStates;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.hasSegmentReplicationStats()) {
            for (String index : this.shardSegmentReplicationStates.keySet()) {
                List<SegmentReplicationState> segmentReplicationStates = this.shardSegmentReplicationStates.get(index);
                if (segmentReplicationStates == null || segmentReplicationStates.size() == 0) continue;
                builder.startObject(index);
                builder.startArray("shards");
                for (SegmentReplicationState segmentReplicationState : segmentReplicationStates) {
                    builder.startObject();
                    segmentReplicationState.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMapOfLists(this.shardSegmentReplicationStates, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

