/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;

public class UpgradeSettingsRequest
extends AcknowledgedRequest<UpgradeSettingsRequest> {
    private Map<String, Tuple<Version, String>> versions;

    public UpgradeSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.versions = in.readMap(StreamInput::readString, i -> new Tuple<Version, String>(Version.readVersion(i), i.readString()));
    }

    public UpgradeSettingsRequest() {
    }

    public UpgradeSettingsRequest(Map<String, Tuple<Version, String>> versions) {
        this.versions = versions;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.versions.isEmpty()) {
            validationException = ValidateActions.addValidationError("no indices to update", validationException);
        }
        return validationException;
    }

    Map<String, Tuple<Version, String>> versions() {
        return this.versions;
    }

    public UpgradeSettingsRequest versions(Map<String, Tuple<Version, String>> versions) {
        this.versions = versions;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.versions, StreamOutput::writeString, (o, v) -> {
            Version.writeVersion((Version)v.v1(), out);
            out.writeString((String)v.v2());
        });
    }
}

