/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.IOException;
import java.util.Collections;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterGetSettingsResponse;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Cancellable;
import org.opensearch.client.ClusterRequestConverters;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.cluster.RemoteInfoRequest;
import org.opensearch.client.cluster.RemoteInfoResponse;
import org.opensearch.client.indices.ComponentTemplatesExistRequest;
import org.opensearch.client.indices.DeleteComponentTemplateRequest;
import org.opensearch.client.indices.GetComponentTemplatesRequest;
import org.opensearch.client.indices.GetComponentTemplatesResponse;
import org.opensearch.client.indices.PutComponentTemplateRequest;
import org.opensearch.rest.RestStatus;

public final class ClusterClient {
    private final RestHighLevelClient restHighLevelClient;

    ClusterClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public ClusterUpdateSettingsResponse putSettings(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(clusterUpdateSettingsRequest, ClusterRequestConverters::clusterPutSettings, options, ClusterUpdateSettingsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putSettingsAsync(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest, RequestOptions options, ActionListener<ClusterUpdateSettingsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(clusterUpdateSettingsRequest, ClusterRequestConverters::clusterPutSettings, options, ClusterUpdateSettingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClusterGetSettingsResponse getSettings(ClusterGetSettingsRequest clusterGetSettingsRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(clusterGetSettingsRequest, ClusterRequestConverters::clusterGetSettings, options, ClusterGetSettingsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getSettingsAsync(ClusterGetSettingsRequest clusterGetSettingsRequest, RequestOptions options, ActionListener<ClusterGetSettingsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(clusterGetSettingsRequest, ClusterRequestConverters::clusterGetSettings, options, ClusterGetSettingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClusterHealthResponse health(ClusterHealthRequest healthRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(healthRequest, ClusterRequestConverters::clusterHealth, options, ClusterHealthResponse::fromXContent, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }

    public Cancellable healthAsync(ClusterHealthRequest healthRequest, RequestOptions options, ActionListener<ClusterHealthResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(healthRequest, ClusterRequestConverters::clusterHealth, options, ClusterHealthResponse::fromXContent, listener, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }

    public RemoteInfoResponse remoteInfo(RemoteInfoRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, ClusterRequestConverters::remoteInfo, options, RemoteInfoResponse::fromXContent, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }

    public Cancellable remoteInfoAsync(RemoteInfoRequest request, RequestOptions options, ActionListener<RemoteInfoResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, ClusterRequestConverters::remoteInfo, options, RemoteInfoResponse::fromXContent, listener, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }

    public AcknowledgedResponse deleteComponentTemplate(DeleteComponentTemplateRequest req, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(req, ClusterRequestConverters::deleteComponentTemplate, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteComponentTemplateAsync(DeleteComponentTemplateRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, ClusterRequestConverters::deleteComponentTemplate, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse putComponentTemplate(PutComponentTemplateRequest putComponentTemplateRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(putComponentTemplateRequest, ClusterRequestConverters::putComponentTemplate, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putComponentTemplateAsync(PutComponentTemplateRequest putComponentTemplateRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(putComponentTemplateRequest, ClusterRequestConverters::putComponentTemplate, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetComponentTemplatesResponse getComponentTemplate(GetComponentTemplatesRequest getComponentTemplatesRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(getComponentTemplatesRequest, ClusterRequestConverters::getComponentTemplates, options, GetComponentTemplatesResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getComponentTemplateAsync(GetComponentTemplatesRequest getComponentTemplatesRequest, RequestOptions options, ActionListener<GetComponentTemplatesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(getComponentTemplatesRequest, ClusterRequestConverters::getComponentTemplates, options, GetComponentTemplatesResponse::fromXContent, listener, Collections.emptySet());
    }

    public boolean existsComponentTemplate(ComponentTemplatesExistRequest componentTemplatesRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequest(componentTemplatesRequest, ClusterRequestConverters::componentTemplatesExist, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    public Cancellable existsComponentTemplateAsync(ComponentTemplatesExistRequest componentTemplatesRequest, RequestOptions options, ActionListener<Boolean> listener) {
        return this.restHighLevelClient.performRequestAsync(componentTemplatesRequest, ClusterRequestConverters::componentTemplatesExist, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }
}

