/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.awarenesshealth;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.awarenesshealth.ClusterAwarenessAttributesHealth;
import org.opensearch.cluster.routing.allocation.AwarenessReplicaBalance;
import org.opensearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public class ClusterAwarenessHealth
implements Writeable,
ToXContentFragment,
Iterable<ClusterAwarenessAttributesHealth> {
    private static final String AWARENESS_ATTRIBUTE = "awareness_attributes";
    private final Map<String, ClusterAwarenessAttributesHealth> clusterAwarenessAttributesHealthMap;

    public ClusterAwarenessHealth(ClusterState clusterState, ClusterSettings clusterSettings, String awarenessAttributeName) {
        this.clusterAwarenessAttributesHealthMap = new HashMap<String, ClusterAwarenessAttributesHealth>();
        List<String> awarenessAttributeList = this.getAwarenessAttributeList(awarenessAttributeName, clusterSettings);
        for (String awarenessAttribute : awarenessAttributeList) {
            boolean displayUnassignedShardLevelInfo = this.canCalcUnassignedShards(clusterSettings, awarenessAttribute);
            ClusterAwarenessAttributesHealth clusterAwarenessAttributesHealth = new ClusterAwarenessAttributesHealth(awarenessAttribute, displayUnassignedShardLevelInfo, clusterState);
            this.clusterAwarenessAttributesHealthMap.put(awarenessAttribute, clusterAwarenessAttributesHealth);
        }
    }

    public ClusterAwarenessHealth(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size > 0) {
            this.clusterAwarenessAttributesHealthMap = new HashMap<String, ClusterAwarenessAttributesHealth>(size);
            for (int i = 0; i < size; ++i) {
                ClusterAwarenessAttributesHealth clusterAwarenessAttributesHealth = new ClusterAwarenessAttributesHealth(in);
                this.clusterAwarenessAttributesHealthMap.put(clusterAwarenessAttributesHealth.getAwarenessAttributeName(), clusterAwarenessAttributesHealth);
            }
        } else {
            this.clusterAwarenessAttributesHealthMap = Collections.emptyMap();
        }
    }

    private List<String> getAwarenessAttributeList(String awarenessAttributeName, ClusterSettings clusterSettings) {
        boolean displayAllAwarenessAttribute = awarenessAttributeName == null || awarenessAttributeName.isBlank();
        ArrayList<String> awarenessAttributeList = new ArrayList<String>();
        if (!displayAllAwarenessAttribute) {
            awarenessAttributeList.add(awarenessAttributeName);
        } else {
            awarenessAttributeList = clusterSettings.get(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING);
        }
        return awarenessAttributeList;
    }

    private boolean canCalcUnassignedShards(ClusterSettings clusterSettings, String awarenessAttributeName) {
        boolean allocationAwarenessBalance = clusterSettings.get(AwarenessReplicaBalance.CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING);
        Settings forcedAwarenessSettings = clusterSettings.get(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING);
        boolean forcedZoneSettingsExists = false;
        if (!forcedAwarenessSettings.isEmpty() && forcedAwarenessSettings.hasValue(awarenessAttributeName + ".values")) {
            forcedZoneSettingsExists = true;
        }
        return allocationAwarenessBalance && forcedZoneSettingsExists;
    }

    public Map<String, ClusterAwarenessAttributesHealth> getClusterAwarenessAttributesHealthMap() {
        return this.clusterAwarenessAttributesHealthMap;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        int size = this.clusterAwarenessAttributesHealthMap.size();
        out.writeVInt(size);
        if (size > 0) {
            for (ClusterAwarenessAttributesHealth awarenessAttributeValueHealth : this) {
                awarenessAttributeValueHealth.writeTo(out);
            }
        }
    }

    public String toString() {
        return "ClusterAwarenessHealth{clusterAwarenessHealth.clusterAwarenessAttributesHealthMap.size=" + (Serializable)(this.clusterAwarenessAttributesHealthMap == null ? "null" : Integer.valueOf(this.clusterAwarenessAttributesHealthMap.size())) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterAwarenessHealth that = (ClusterAwarenessHealth)o;
        return this.clusterAwarenessAttributesHealthMap.size() == that.clusterAwarenessAttributesHealthMap.size();
    }

    public int hashCode() {
        return Objects.hash(this.clusterAwarenessAttributesHealthMap);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(AWARENESS_ATTRIBUTE);
        for (ClusterAwarenessAttributesHealth awarenessAttributeValueHealth : this) {
            awarenessAttributeValueHealth.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public Iterator<ClusterAwarenessAttributesHealth> iterator() {
        return this.clusterAwarenessAttributesHealthMap.values().iterator();
    }
}

