/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.cluster.AbstractNamedDiffable;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.WeightedRouting;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class WeightedRoutingMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    private static final Logger logger = LogManager.getLogger(WeightedRoutingMetadata.class);
    public static final String TYPE = "weighted_shard_routing";
    public static final String AWARENESS = "awareness";
    public static final String VERSION = "_version";
    public static final long INITIAL_VERSION = -1L;
    public static final long VERSION_UNSET_VALUE = -2L;
    public static final int WEIGHED_AWAY_WEIGHT = 0;
    private long version;
    private WeightedRouting weightedRouting;

    public long getVersion() {
        return this.version;
    }

    public WeightedRouting getWeightedRouting() {
        return this.weightedRouting;
    }

    public WeightedRoutingMetadata setWeightedRouting(WeightedRouting weightedRouting) {
        this.weightedRouting = weightedRouting;
        return this;
    }

    public WeightedRoutingMetadata(StreamInput in) throws IOException {
        if (in.available() != 0) {
            this.weightedRouting = new WeightedRouting(in);
            this.version = in.readLong();
        }
    }

    public WeightedRoutingMetadata(WeightedRouting weightedRouting, long version) {
        this.weightedRouting = weightedRouting;
        this.version = version;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.API_AND_GATEWAY;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_2_4_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.weightedRouting != null) {
            this.weightedRouting.writeTo(out);
            out.writeLong(this.version);
        }
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return WeightedRoutingMetadata.readDiffFrom(Metadata.Custom.class, TYPE, in);
    }

    public static WeightedRoutingMetadata fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String attrKey = null;
        String attributeName = null;
        HashMap<String, Double> weights = new HashMap<String, Double>();
        String versionAttr = null;
        long version = -2L;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String attr = parser.currentName();
                if (attr != null && attr.equals(VERSION)) {
                    versionAttr = parser.currentName();
                    continue;
                }
                String awarenessField = parser.currentName();
                if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                    throw new OpenSearchParseException("failed to parse weighted routing metadata  [{}], expected object", awarenessField);
                }
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    attributeName = parser.currentName();
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new OpenSearchParseException("failed to parse weighted routing metadata  [{}], expected object", attributeName);
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            attrKey = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            if (attrKey != null && attrKey.equals(VERSION)) {
                                version = Long.parseLong(parser.text());
                                continue;
                            }
                            Double attrValue = Double.parseDouble(parser.text());
                            weights.put(attrKey, attrValue);
                            continue;
                        }
                        throw new OpenSearchParseException("failed to parse weighted routing metadata attribute [{}], unknown type", attributeName);
                    }
                }
                continue;
            }
            if (token != XContentParser.Token.VALUE_NUMBER || versionAttr == null || !versionAttr.equals(VERSION)) continue;
            version = Long.parseLong(parser.text());
        }
        WeightedRouting weightedRouting = new WeightedRouting(attributeName, weights);
        return new WeightedRoutingMetadata(weightedRouting, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedRoutingMetadata that = (WeightedRoutingMetadata)o;
        return this.weightedRouting.equals(that.weightedRouting);
    }

    public int hashCode() {
        return this.weightedRouting.hashCode();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        WeightedRoutingMetadata.toXContent(this.weightedRouting, builder, this.version);
        return builder;
    }

    public static void toXContent(WeightedRouting weightedRouting, XContentBuilder builder, long version) throws IOException {
        builder.startObject(AWARENESS);
        if (weightedRouting.isSet()) {
            builder.startObject(weightedRouting.attributeName());
            for (Map.Entry<String, Double> entry : weightedRouting.weights().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
            builder.endObject();
        }
        builder.endObject();
        builder.field(VERSION, version);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

