/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public abstract class Decision
implements ToXContent,
Writeable {
    public static final Decision ALWAYS = new Single(Type.YES);
    public static final Decision YES = new Single(Type.YES);
    public static final Decision NO = new Single(Type.NO);
    public static final Decision THROTTLE = new Single(Type.THROTTLE);

    public static Decision single(Type type, @Nullable String label, @Nullable String explanation, Object ... explanationParams) {
        return new Single(type, label, explanation, explanationParams);
    }

    public static Decision readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            Multi result = new Multi();
            int decisionCount = in.readVInt();
            for (int i = 0; i < decisionCount; ++i) {
                Decision s = Decision.readFrom(in);
                result.decisions.add(s);
            }
            return result;
        }
        Single result = new Single();
        result.type = Type.readFrom(in);
        result.label = in.readOptionalString();
        result.explanationString = in.readOptionalString();
        return result;
    }

    public abstract Type type();

    @Nullable
    public abstract String label();

    @Nullable
    public abstract String getExplanation();

    public abstract List<Decision> getDecisions();

    public static class Single
    extends Decision
    implements ToXContentObject {
        private Type type;
        private String label;
        private String explanation;
        private String explanationString;
        private Object[] explanationParams;

        public Single() {
        }

        public Single(Type type) {
            this(type, null, null, null);
        }

        public Single(Type type, @Nullable String label, @Nullable String explanation, Object ... explanationParams) {
            this.type = type;
            this.label = label;
            this.explanation = explanation;
            this.explanationParams = explanationParams;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        @Nullable
        public String label() {
            return this.label;
        }

        @Override
        public List<Decision> getDecisions() {
            return Collections.singletonList(this);
        }

        @Override
        @Nullable
        public String getExplanation() {
            if (this.explanationString == null && this.explanation != null) {
                this.explanationString = String.format(Locale.ROOT, this.explanation, this.explanationParams);
            }
            return this.explanationString;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Single s = (Single)object;
            return this.type == s.type && Objects.equals(this.label, s.label) && Objects.equals(this.getExplanation(), s.getExplanation());
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            String explanationStr = this.getExplanation();
            result = 31 * result + (explanationStr == null ? 0 : explanationStr.hashCode());
            return result;
        }

        public String toString() {
            if (this.explanationString != null || this.explanation != null) {
                return this.type + "(" + this.getExplanation() + ")";
            }
            return this.type + "()";
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("decider", this.label);
            builder.field("decision", this.type);
            String explanation = this.getExplanation();
            builder.field("explanation", explanation != null ? explanation : "none");
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(false);
            this.type.writeTo(out);
            out.writeOptionalString(this.label);
            out.writeOptionalString(this.getExplanation());
        }
    }

    public static enum Type implements Writeable
    {
        YES(1),
        THROTTLE(2),
        NO(0);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public static Type readFrom(StreamInput in) throws IOException {
            int i = in.readVInt();
            switch (i) {
                case 0: {
                    return NO;
                }
                case 1: {
                    return YES;
                }
                case 2: {
                    return THROTTLE;
                }
            }
            throw new IllegalArgumentException("No Type for integer [" + i + "]");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.id);
        }

        public boolean higherThan(Type other) {
            if (this == NO) {
                return false;
            }
            if (other == NO) {
                return true;
            }
            return other == THROTTLE && this == YES;
        }

        public boolean canPremptivelyReturn() {
            return this == THROTTLE || this == NO;
        }
    }

    public static class Multi
    extends Decision
    implements ToXContentFragment {
        private final List<Decision> decisions = new ArrayList<Decision>();

        public Multi add(Decision decision) {
            this.decisions.add(decision);
            return this;
        }

        @Override
        public Type type() {
            Type ret = Type.YES;
            for (int i = 0; i < this.decisions.size(); ++i) {
                Type type = this.decisions.get(i).type();
                if (type == Type.NO) {
                    return type;
                }
                if (type != Type.THROTTLE) continue;
                ret = type;
            }
            return ret;
        }

        @Override
        @Nullable
        public String label() {
            return null;
        }

        @Override
        @Nullable
        public String getExplanation() {
            throw new UnsupportedOperationException("multi-level decisions do not have an explanation");
        }

        @Override
        public List<Decision> getDecisions() {
            return Collections.unmodifiableList(this.decisions);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Multi m = (Multi)object;
            return this.decisions.equals(m.decisions);
        }

        public int hashCode() {
            return 31 * this.decisions.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Decision decision : this.decisions) {
                sb.append("[").append(decision.toString()).append("]");
            }
            return sb.toString();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (Decision d : this.decisions) {
                d.toXContent(builder, params);
            }
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(true);
            out.writeVInt(this.getDecisions().size());
            for (Decision d : this.getDecisions()) {
                d.writeTo(out);
            }
        }
    }
}

