/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.collect;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Iterator;

public final class HppcMaps {
    private HppcMaps() {
    }

    public static <K, V> ObjectObjectHashMap<K, V> newMap(int expectedElements) {
        return new ObjectObjectHashMap(expectedElements);
    }

    public static <K, V> ObjectObjectHashMap<K, V> newMap() {
        return HppcMaps.newMap(16);
    }

    public static <K, V> ObjectObjectHashMap<K, V> newNoNullKeysMap() {
        return HppcMaps.ensureNoNullKeys(16);
    }

    public static <K, V> ObjectObjectHashMap<K, V> newNoNullKeysMap(int expectedElements) {
        return HppcMaps.ensureNoNullKeys(expectedElements);
    }

    public static <K, V> ObjectObjectHashMap<K, V> ensureNoNullKeys(int expectedElements) {
        return new ObjectObjectHashMap<K, V>(expectedElements){

            @Override
            public V put(K key, V value) {
                if (key == null) {
                    throw new IllegalArgumentException("Map key must not be null");
                }
                return super.put(key, value);
            }
        };
    }

    public static <T> Iterable<T> intersection(ObjectLookupContainer<T> container1, final ObjectLookupContainer<T> container2) {
        assert (container1 != null && container2 != null);
        final Iterator iterator = container1.iterator();
        final Iterator intersection = new Iterator<T>(){
            T current;

            @Override
            public boolean hasNext() {
                if (iterator.hasNext()) {
                    do {
                        java.lang.Object next;
                        if (!container2.contains(next = ((ObjectCursor)iterator.next()).value)) continue;
                        this.current = next;
                        return true;
                    } while (iterator.hasNext());
                }
                return false;
            }

            @Override
            public T next() {
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return intersection;
            }
        };
    }

    public static final class Object {

        public static final class Integer {
            public static <V> ObjectIntHashMap<V> ensureNoNullKeys(int capacity, float loadFactor) {
                return new ObjectIntHashMap<V>(capacity, loadFactor){

                    @Override
                    public int put(V key, int value) {
                        if (key == null) {
                            throw new IllegalArgumentException("Map key must not be null");
                        }
                        return super.put(key, value);
                    }
                };
            }
        }
    }
}

