/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo.builders;

import java.io.IOException;
import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.shape.Circle;
import org.opensearch.common.ParseField;
import org.opensearch.common.geo.GeoShapeType;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.common.geo.parsers.ShapeParser;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.unit.DistanceUnit;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;

public class CircleBuilder
extends ShapeBuilder<Circle, org.opensearch.geometry.Circle, CircleBuilder> {
    public static final ParseField FIELD_RADIUS = new ParseField("radius", new String[0]);
    public static final GeoShapeType TYPE = GeoShapeType.CIRCLE;
    private DistanceUnit unit = DistanceUnit.DEFAULT;
    private double radius;
    private Coordinate center;

    public CircleBuilder() {
        this.center = ZERO_ZERO;
    }

    public CircleBuilder(StreamInput in) throws IOException {
        this.center(CircleBuilder.readFromStream(in));
        this.radius(in.readDouble(), DistanceUnit.readFromStream(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        CircleBuilder.writeCoordinateTo(this.center, out);
        out.writeDouble(this.radius);
        this.unit.writeTo(out);
    }

    public CircleBuilder center(Coordinate center) {
        this.center = center;
        return this;
    }

    public CircleBuilder center(double lon, double lat) {
        return this.center(new Coordinate(lon, lat));
    }

    public Coordinate center() {
        return this.center;
    }

    public CircleBuilder radius(String radius) {
        return this.radius(DistanceUnit.Distance.parseDistance(radius));
    }

    public CircleBuilder radius(DistanceUnit.Distance radius) {
        return this.radius(radius.value, radius.unit);
    }

    public CircleBuilder radius(double radius, String unit) {
        return this.radius(radius, DistanceUnit.fromString(unit));
    }

    public CircleBuilder radius(double radius, DistanceUnit unit) {
        this.unit = unit;
        this.radius = radius;
        return this;
    }

    public double radius() {
        return this.radius;
    }

    public DistanceUnit unit() {
        return this.unit;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.field(FIELD_RADIUS.getPreferredName(), this.unit.toString(this.radius));
        builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
        CircleBuilder.toXContent(builder, this.center);
        return builder.endObject();
    }

    @Override
    public Circle buildS4J() {
        return SPATIAL_CONTEXT.makeCircle(this.center.x, this.center.y, 360.0 * this.radius / this.unit.getEarthCircumference());
    }

    @Override
    public org.opensearch.geometry.Circle buildGeometry() {
        return new org.opensearch.geometry.Circle(this.center.x, this.center.y, this.unit.toMeters(this.radius));
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }

    @Override
    public String toWKT() {
        throw new UnsupportedOperationException("The WKT spec does not support CIRCLE geometry");
    }

    @Override
    public int numDimensions() {
        return Double.isNaN(this.center.z) ? 2 : 3;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.center, this.radius, this.unit.ordinal());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CircleBuilder other = (CircleBuilder)obj;
        return Objects.equals(this.center, other.center) && Objects.equals(this.radius, other.radius) && Objects.equals(this.unit.ordinal(), other.unit.ordinal());
    }
}

