/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.index;

import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.opensearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.opensearch.index.shard.ShardId;

public final class OpenSearchLeafReader
extends SequentialStoredFieldsLeafReader {
    private final ShardId shardId;

    public OpenSearchLeafReader(LeafReader in, ShardId shardId) {
        super(in);
        this.shardId = shardId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public static OpenSearchLeafReader getOpenSearchLeafReader(LeafReader reader) {
        if (reader instanceof FilterLeafReader) {
            if (reader instanceof OpenSearchLeafReader) {
                return (OpenSearchLeafReader)reader;
            }
            return OpenSearchLeafReader.getOpenSearchLeafReader(((FilterLeafReader)reader).getDelegate());
        }
        return null;
    }

    @Override
    protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
        return reader;
    }
}

