/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.search;

import java.util.ArrayList;
import java.util.PrimitiveIterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;

public class AutomatonQueries {
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';
    public static final char WILDCARD_ESCAPE = '\\';

    public static Automaton caseInsensitivePrefix(String s) {
        ArrayList<Automaton> list = new ArrayList<Automaton>();
        PrimitiveIterator.OfInt iter = s.codePoints().iterator();
        while (iter.hasNext()) {
            list.add(AutomatonQueries.toCaseInsensitiveChar((Integer)iter.next(), Integer.MAX_VALUE));
        }
        list.add(Automata.makeAnyString());
        Automaton a = Operations.concatenate(list);
        a = MinimizationOperations.minimize(a, Integer.MAX_VALUE);
        return a;
    }

    public static AutomatonQuery caseInsensitivePrefixQuery(Term prefix) {
        return AutomatonQueries.caseInsensitivePrefixQuery(prefix, MultiTermQuery.CONSTANT_SCORE_REWRITE);
    }

    public static AutomatonQuery caseInsensitivePrefixQuery(Term prefix, MultiTermQuery.RewriteMethod method) {
        return AutomatonQueries.createAutomatonQuery(prefix, AutomatonQueries.caseInsensitivePrefix(prefix.text()), method);
    }

    public static AutomatonQuery caseInsensitiveTermQuery(Term term) {
        BytesRef prefix = term.bytes();
        return new AutomatonQuery(term, AutomatonQueries.toCaseInsensitiveString(prefix, Integer.MAX_VALUE));
    }

    public static AutomatonQuery caseInsensitiveWildcardQuery(Term wildcardquery, MultiTermQuery.RewriteMethod method) {
        return AutomatonQueries.createAutomatonQuery(wildcardquery, AutomatonQueries.toCaseInsensitiveWildcardAutomaton(wildcardquery, Integer.MAX_VALUE), method);
    }

    public static AutomatonQuery createAutomatonQuery(Term term, Automaton automaton, MultiTermQuery.RewriteMethod method) {
        if (method == null) {
            method = MultiTermQuery.CONSTANT_SCORE_REWRITE;
        }
        return new AutomatonQuery(term, automaton, 10000, false, method);
    }

    public static Automaton toCaseInsensitiveWildcardAutomaton(Term wildcardquery, int maxDeterminizedStates) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        String wildcardText = wildcardquery.text();
        block5: for (int i = 0; i < wildcardText.length(); i += length) {
            int c = wildcardText.codePointAt(i);
            length = Character.charCount(c);
            switch (c) {
                case 42: {
                    automata.add(Automata.makeAnyString());
                    continue block5;
                }
                case 63: {
                    automata.add(Automata.makeAnyChar());
                    continue block5;
                }
                case 92: {
                    if (i + length < wildcardText.length()) {
                        int nextChar = wildcardText.codePointAt(i + length);
                        length += Character.charCount(nextChar);
                        automata.add(Automata.makeChar(nextChar));
                        continue block5;
                    }
                }
                default: {
                    automata.add(AutomatonQueries.toCaseInsensitiveChar(c, maxDeterminizedStates));
                }
            }
        }
        return Operations.concatenate(automata);
    }

    protected static Automaton toCaseInsensitiveString(BytesRef br, int maxDeterminizedStates) {
        return AutomatonQueries.toCaseInsensitiveString(br.utf8ToString(), maxDeterminizedStates);
    }

    public static Automaton toCaseInsensitiveString(String s, int maxDeterminizedStates) {
        ArrayList<Automaton> list = new ArrayList<Automaton>();
        PrimitiveIterator.OfInt iter = s.codePoints().iterator();
        while (iter.hasNext()) {
            list.add(AutomatonQueries.toCaseInsensitiveChar((Integer)iter.next(), maxDeterminizedStates));
        }
        Automaton a = Operations.concatenate(list);
        a = MinimizationOperations.minimize(a, maxDeterminizedStates);
        return a;
    }

    public static Automaton toCaseInsensitiveChar(int codepoint, int maxDeterminizedStates) {
        Automaton result;
        int altCase;
        Automaton case1 = Automata.makeChar(codepoint);
        if (codepoint > 128) {
            return case1;
        }
        int n = altCase = Character.isLowerCase(codepoint) ? Character.toUpperCase(codepoint) : Character.toLowerCase(codepoint);
        if (altCase != codepoint) {
            result = Operations.union(case1, Automata.makeChar(altCase));
            result = MinimizationOperations.minimize(result, maxDeterminizedStates);
        } else {
            result = case1;
        }
        return result;
    }
}

