/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

public class MovingAverage {
    private final int windowSize;
    private final long[] observations;
    private long count = 0L;
    private long sum = 0L;
    private double average = 0.0;

    public MovingAverage(int windowSize) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("window size must be greater than zero");
        }
        this.windowSize = windowSize;
        this.observations = new long[windowSize];
    }

    public synchronized double record(long value) {
        long delta = value - this.observations[(int)(this.count % (long)this.observations.length)];
        this.observations[(int)(this.count % (long)this.observations.length)] = value;
        ++this.count;
        this.sum += delta;
        this.average = (double)this.sum / (double)Math.min(this.count, (long)this.observations.length);
        return this.average;
    }

    public double getAverage() {
        return this.average;
    }

    public long getCount() {
        return this.count;
    }

    public boolean isReady() {
        return this.count >= (long)this.windowSize;
    }
}

