/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.rest.RestRequest;
import org.opensearch.transport.TransportRequest;

public class ExtensionRestRequest
extends TransportRequest {
    private RestRequest.Method method;
    private String path;
    private Map<String, String> params;
    private XContentType xContentType = null;
    private BytesReference content;
    private String principalIdentifierToken;
    private final Set<String> consumedParams = new HashSet<String>();
    private boolean contentConsumed = false;

    public ExtensionRestRequest(RestRequest.Method method, String path, Map<String, String> params, XContentType xContentType, BytesReference content, String principalIdentifier) {
        this.method = method;
        this.path = path;
        this.params = params;
        this.xContentType = xContentType;
        this.content = content;
        this.principalIdentifierToken = principalIdentifier;
    }

    public ExtensionRestRequest(StreamInput in) throws IOException {
        super(in);
        this.method = in.readEnum(RestRequest.Method.class);
        this.path = in.readString();
        this.params = in.readMap(StreamInput::readString, StreamInput::readString);
        if (in.readBoolean()) {
            this.xContentType = in.readEnum(XContentType.class);
        }
        this.content = in.readBytesReference();
        this.principalIdentifierToken = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum(this.method);
        out.writeString(this.path);
        out.writeMap(this.params, StreamOutput::writeString, StreamOutput::writeString);
        out.writeBoolean(this.xContentType != null);
        if (this.xContentType != null) {
            out.writeEnum(this.xContentType);
        }
        out.writeBytesReference(this.content);
        out.writeString(this.principalIdentifierToken);
    }

    public RestRequest.Method method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public String param(String key) {
        this.consumedParams.add(key);
        return this.params.get(key);
    }

    public String param(String key, String defaultValue) {
        this.consumedParams.add(key);
        return this.params.getOrDefault(key, defaultValue);
    }

    public long paramAsLong(String key, long defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to parse param '" + key + "' value '" + value + "' to a long.", e);
        }
    }

    public List<String> consumedParams() {
        return new ArrayList<String>(this.consumedParams);
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public BytesReference content() {
        this.contentConsumed = true;
        return this.content;
    }

    public boolean hasContent() {
        return this.content.length() > 0;
    }

    public boolean isContentConsumed() {
        return this.contentConsumed;
    }

    public final XContentParser contentParser(NamedXContentRegistry xContentRegistry) throws IOException {
        if (!this.hasContent() || this.getXContentType() == null) {
            throw new OpenSearchParseException("There is no request body or the ContentType is invalid.", new Object[0]);
        }
        return this.getXContentType().xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, this.content.streamInput());
    }

    public String getRequestIssuerIdentity() {
        return this.principalIdentifierToken;
    }

    public String toString() {
        return "ExtensionRestRequest{method=" + this.method + ", path=" + this.path + ", params=" + this.params + ", xContentType=" + this.xContentType + ", contentLength=" + this.content.length() + ", requester=" + this.principalIdentifierToken + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionRestRequest that = (ExtensionRestRequest)obj;
        return Objects.equals((Object)this.method, (Object)that.method) && Objects.equals(this.path, that.path) && Objects.equals(this.params, that.params) && Objects.equals(this.xContentType, that.xContentType) && Objects.equals(this.content, that.content) && Objects.equals(this.principalIdentifierToken, that.principalIdentifierToken);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.path, this.params, this.xContentType, this.content, this.principalIdentifierToken});
    }
}

