/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexGraveyard;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Manifest;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.gateway.MetadataStateFormat;
import org.opensearch.gateway.WriteStateException;
import org.opensearch.index.Index;

public class MetaStateService {
    private static final Logger logger = LogManager.getLogger(MetaStateService.class);
    private final NodeEnvironment nodeEnv;
    private final NamedXContentRegistry namedXContentRegistry;
    protected MetadataStateFormat<Metadata> METADATA_FORMAT = Metadata.FORMAT;
    protected MetadataStateFormat<IndexMetadata> INDEX_METADATA_FORMAT = IndexMetadata.FORMAT;
    protected MetadataStateFormat<Manifest> MANIFEST_FORMAT = Manifest.FORMAT;

    public MetaStateService(NodeEnvironment nodeEnv, NamedXContentRegistry namedXContentRegistry) {
        this.nodeEnv = nodeEnv;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public Tuple<Manifest, Metadata> loadFullState() throws IOException {
        Metadata.Builder metadataBuilder;
        Manifest manifest = this.MANIFEST_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        if (manifest == null) {
            return this.loadFullStateBWC();
        }
        if (manifest.isGlobalGenerationMissing()) {
            metadataBuilder = Metadata.builder();
        } else {
            Metadata globalMetadata = this.METADATA_FORMAT.loadGeneration(logger, this.namedXContentRegistry, manifest.getGlobalGeneration(), this.nodeEnv.nodeDataPaths());
            if (globalMetadata != null) {
                metadataBuilder = Metadata.builder(globalMetadata);
            } else {
                throw new IOException("failed to find global metadata [generation: " + manifest.getGlobalGeneration() + "]");
            }
        }
        for (Map.Entry<Index, Long> entry : manifest.getIndexGenerations().entrySet()) {
            String indexFolderName;
            Index index = entry.getKey();
            long generation = entry.getValue();
            IndexMetadata indexMetadata = this.INDEX_METADATA_FORMAT.loadGeneration(logger, this.namedXContentRegistry, generation, this.nodeEnv.resolveIndexFolder(indexFolderName = index.getUUID()));
            if (indexMetadata != null) {
                metadataBuilder.put(indexMetadata, false);
                continue;
            }
            throw new IOException("failed to find metadata for existing index " + index.getName() + " [location: " + indexFolderName + ", generation: " + generation + "]");
        }
        return new Tuple<Manifest, Metadata>(manifest, metadataBuilder.build());
    }

    private Tuple<Manifest, Metadata> loadFullStateBWC() throws IOException {
        IndexGraveyard indexGraveyard;
        Metadata.Builder metadataBuilder;
        HashMap<Index, Long> indices = new HashMap<Index, Long>();
        Tuple<Metadata, Long> metadataAndGeneration = this.METADATA_FORMAT.loadLatestStateWithGeneration(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        Metadata globalMetadata = metadataAndGeneration.v1();
        long globalStateGeneration = metadataAndGeneration.v2();
        if (globalMetadata != null) {
            metadataBuilder = Metadata.builder(globalMetadata);
            indexGraveyard = (IndexGraveyard)globalMetadata.custom("index-graveyard");
            assert (Version.CURRENT.major < 8) : "failed to find manifest file, which is mandatory staring with OpenSearch version 1.0.0";
        } else {
            metadataBuilder = Metadata.builder();
            indexGraveyard = IndexGraveyard.builder().build();
        }
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            Tuple<IndexMetadata, Long> indexMetadataAndGeneration = this.INDEX_METADATA_FORMAT.loadLatestStateWithGeneration(logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            assert (Version.CURRENT.major < 8) : "failed to find manifest file, which is mandatory staring with OpenSearch version 1.0.0";
            IndexMetadata indexMetadata = indexMetadataAndGeneration.v1();
            long generation = indexMetadataAndGeneration.v2();
            if (indexMetadata != null) {
                if (indexGraveyard.containsIndex(indexMetadata.getIndex())) {
                    logger.debug("[{}] found metadata for deleted index [{}]", (Object)indexFolderName, (Object)indexMetadata.getIndex());
                    continue;
                }
                indices.put(indexMetadata.getIndex(), generation);
                metadataBuilder.put(indexMetadata, false);
                continue;
            }
            logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        Manifest manifest = Manifest.unknownCurrentTermAndVersion(globalStateGeneration, indices);
        return new Tuple<Manifest, Metadata>(manifest, metadataBuilder.build());
    }

    @Nullable
    public IndexMetadata loadIndexState(Index index) throws IOException {
        return this.INDEX_METADATA_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.indexPaths(index));
    }

    List<IndexMetadata> loadIndicesStates(Predicate<String> excludeIndexPathIdsPredicate) throws IOException {
        ArrayList<IndexMetadata> indexMetadataList = new ArrayList<IndexMetadata>();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders(excludeIndexPathIdsPredicate)) {
            assert (!excludeIndexPathIdsPredicate.test(indexFolderName)) : "unexpected folder " + indexFolderName + " which should have been excluded";
            IndexMetadata indexMetadata = this.INDEX_METADATA_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetadata != null) {
                String indexPathId = indexMetadata.getIndex().getUUID();
                if (indexFolderName.equals(indexPathId)) {
                    indexMetadataList.add(indexMetadata);
                    continue;
                }
                throw new IllegalStateException("[" + indexFolderName + "] invalid index folder name, rename to [" + indexPathId + "]");
            }
            logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return indexMetadataList;
    }

    public Manifest loadManifestOrEmpty() throws IOException {
        Manifest manifest = this.MANIFEST_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        if (manifest == null) {
            manifest = Manifest.empty();
        }
        return manifest;
    }

    Metadata loadGlobalState() throws IOException {
        return this.METADATA_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
    }

    public void writeManifestAndCleanup(String reason, Manifest manifest) throws WriteStateException {
        logger.trace("[_meta] writing state, reason [{}]", (Object)reason);
        try {
            long generation = this.MANIFEST_FORMAT.writeAndCleanup(manifest, this.nodeEnv.nodeDataPaths());
            logger.trace("[_meta] state written (generation: {})", (Object)generation);
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(ex.isDirty(), "[_meta]: failed to write meta state", ex);
        }
    }

    public long writeIndex(String reason, IndexMetadata indexMetadata) throws WriteStateException {
        Index index = indexMetadata.getIndex();
        logger.trace("[{}] writing state, reason [{}]", (Object)index, (Object)reason);
        try {
            long generation = this.INDEX_METADATA_FORMAT.write(indexMetadata, this.nodeEnv.indexPaths(indexMetadata.getIndex()));
            logger.trace("[{}] state written", (Object)index);
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[" + index + "]: failed to write index state", ex);
        }
    }

    long writeGlobalState(String reason, Metadata metadata) throws WriteStateException {
        logger.trace("[_global] writing state, reason [{}]", (Object)reason);
        try {
            long generation = this.METADATA_FORMAT.write(metadata, this.nodeEnv.nodeDataPaths());
            logger.trace("[_global] state written");
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[_global]: failed to write global state", ex);
        }
    }

    void cleanupGlobalState(long currentGeneration) {
        this.METADATA_FORMAT.cleanupOldFiles(currentGeneration, this.nodeEnv.nodeDataPaths());
    }

    public void cleanupIndex(Index index, long currentGeneration) {
        this.INDEX_METADATA_FORMAT.cleanupOldFiles(currentGeneration, this.nodeEnv.indexPaths(index));
    }

    public void unreferenceAll() throws IOException {
        this.MANIFEST_FORMAT.writeAndCleanup(Manifest.empty(), this.nodeEnv.nodeDataPaths());
        this.METADATA_FORMAT.cleanupOldFiles(Long.MAX_VALUE, this.nodeEnv.nodeDataPaths());
    }

    public void deleteAll() throws IOException {
        this.unreferenceAll();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            MetadataStateFormat.deleteMetaState(this.nodeEnv.resolveIndexFolder(indexFolderName));
        }
        this.MANIFEST_FORMAT.cleanupOldFiles(Long.MAX_VALUE, this.nodeEnv.nodeDataPaths());
    }
}

