/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.breaker.CircuitBreaker;
import org.opensearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;

public final class RamAccountingTermsEnum
extends FilteredTermsEnum {
    private static final long FLUSH_BUFFER_SIZE = 0x500000L;
    private final CircuitBreaker breaker;
    private final TermsEnum termsEnum;
    private final AbstractIndexOrdinalsFieldData.PerValueEstimator estimator;
    private final String fieldName;
    private long totalBytes;
    private long flushBuffer;

    public RamAccountingTermsEnum(TermsEnum termsEnum, CircuitBreaker breaker, AbstractIndexOrdinalsFieldData.PerValueEstimator estimator, String fieldName) {
        super(termsEnum);
        this.breaker = breaker;
        this.termsEnum = termsEnum;
        this.estimator = estimator;
        this.fieldName = fieldName;
        this.totalBytes = 0L;
        this.flushBuffer = 0L;
    }

    @Override
    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
        return FilteredTermsEnum.AcceptStatus.YES;
    }

    public void flush() {
        this.breaker.addEstimateBytesAndMaybeBreak(this.flushBuffer, this.fieldName);
        this.totalBytes += this.flushBuffer;
        this.flushBuffer = 0L;
    }

    @Override
    public BytesRef next() throws IOException {
        BytesRef term = this.termsEnum.next();
        if (term == null && this.flushBuffer != 0L) {
            this.flush();
        } else {
            this.flushBuffer += this.estimator.bytesPerValue(term);
            if (this.flushBuffer >= 0x500000L) {
                this.flush();
            }
        }
        return term;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }
}

