/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;

public final class OpenSearchToParentBlockJoinQuery
extends Query {
    private final ToParentBlockJoinQuery query;
    private final String path;
    private final ScoreMode scoreMode;

    public OpenSearchToParentBlockJoinQuery(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode, String path) {
        this(new ToParentBlockJoinQuery(childQuery, parentsFilter, scoreMode), path, scoreMode);
    }

    private OpenSearchToParentBlockJoinQuery(ToParentBlockJoinQuery query, String path, ScoreMode scoreMode) {
        this.query = query;
        this.path = path;
        this.scoreMode = scoreMode;
    }

    public Query getChildQuery() {
        return this.query.getChildQuery();
    }

    public String getPath() {
        return this.path;
    }

    public ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query innerRewrite = this.query.rewrite(reader);
        if (innerRewrite != this.query) {
            if (innerRewrite instanceof ToParentBlockJoinQuery) {
                return new OpenSearchToParentBlockJoinQuery((ToParentBlockJoinQuery)innerRewrite, this.path, this.scoreMode);
            }
            return innerRewrite;
        }
        return super.rewrite(reader);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.query.getChildQuery().visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, org.apache.lucene.search.ScoreMode scoreMode, float boost) throws IOException {
        return this.query.createWeight(searcher, scoreMode, boost);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        OpenSearchToParentBlockJoinQuery that = (OpenSearchToParentBlockJoinQuery)obj;
        return this.query.equals(that.query) && Objects.equals(this.path, that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.query, this.path);
    }

    @Override
    public String toString(String field) {
        return this.query.toString(field);
    }
}

