/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ReferenceManager;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;

public class CheckpointRefreshListener
implements ReferenceManager.RefreshListener {
    protected static Logger logger = LogManager.getLogger(CheckpointRefreshListener.class);
    private final IndexShard shard;
    private final SegmentReplicationCheckpointPublisher publisher;

    public CheckpointRefreshListener(IndexShard shard, SegmentReplicationCheckpointPublisher publisher) {
        this.shard = shard;
        this.publisher = publisher;
    }

    @Override
    public void beforeRefresh() throws IOException {
    }

    @Override
    public void afterRefresh(boolean didRefresh) throws IOException {
        if (didRefresh && this.shard.state() != IndexShardState.CLOSED && this.shard.getReplicationTracker().isPrimaryMode()) {
            this.publisher.publish(this.shard);
        }
    }
}

