/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public class DocsStats
implements Writeable,
ToXContentFragment {
    private long count = 0L;
    private long deleted = 0L;
    private long totalSizeInBytes = 0L;

    public DocsStats() {
    }

    public DocsStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.deleted = in.readVLong();
        this.totalSizeInBytes = in.readVLong();
    }

    public DocsStats(long count, long deleted, long totalSizeInBytes) {
        this.count = count;
        this.deleted = deleted;
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public void add(DocsStats other) {
        if (other == null) {
            return;
        }
        if (this.totalSizeInBytes == -1L) {
            this.totalSizeInBytes = other.totalSizeInBytes;
        } else if (other.totalSizeInBytes != -1L) {
            this.totalSizeInBytes += other.totalSizeInBytes;
        }
        this.count += other.count;
        this.deleted += other.deleted;
    }

    public long getCount() {
        return this.count;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public long getAverageSizeInBytes() {
        long totalDocs = this.count + this.deleted;
        return totalDocs == 0L ? 0L : this.totalSizeInBytes / totalDocs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeVLong(this.deleted);
        out.writeVLong(this.totalSizeInBytes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("docs");
        builder.field("count", this.count);
        builder.field("deleted", this.deleted);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String DOCS = "docs";
        static final String COUNT = "count";
        static final String DELETED = "deleted";

        Fields() {
        }
    }
}

