/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.index.store.RemoteIndexInput;
import org.opensearch.index.store.RemoteIndexOutput;

public class RemoteDirectory
extends Directory {
    private final BlobContainer blobContainer;

    public RemoteDirectory(BlobContainer blobContainer) {
        this.blobContainer = blobContainer;
    }

    @Override
    public String[] listAll() throws IOException {
        return (String[])this.blobContainer.listBlobs().keySet().stream().sorted().toArray(String[]::new);
    }

    public Collection<String> listFilesByPrefix(String filenamePrefix) throws IOException {
        return this.blobContainer.listBlobsByPrefix(filenamePrefix).keySet();
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.blobContainer.deleteBlobsIgnoringIfNotExists(Collections.singletonList(name));
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) {
        return new RemoteIndexOutput(name, this.blobContainer);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        return new RemoteIndexInput(name, this.blobContainer.readBlob(name), this.fileLength(name));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public long fileLength(String name) throws IOException {
        Map<String, BlobMetadata> metadata = this.blobContainer.listBlobsByPrefix(name);
        if (metadata.containsKey(name)) {
            return metadata.get(name).length();
        }
        throw new NoSuchFileException(name);
    }

    @Override
    public Set<String> getPendingDeletions() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void syncMetaData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock obtainLock(String name) throws IOException {
        throw new UnsupportedOperationException();
    }
}

