/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.lucene.store.InputStreamIndexInput;

public class RemoteIndexOutput
extends IndexOutput {
    private final BlobContainer blobContainer;

    public RemoteIndexOutput(String name, BlobContainer blobContainer) {
        super(name, name);
        this.blobContainer = blobContainer;
    }

    @Override
    public void copyBytes(DataInput input, long numBytes) throws IOException {
        assert (input instanceof IndexInput) : "input should be instance of IndexInput";
        this.blobContainer.writeBlob(this.getName(), new InputStreamIndexInput((IndexInput)input, numBytes), numBytes, false);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeByte(byte b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeBytes(byte[] byteArray, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getFilePointer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getChecksum() throws IOException {
        throw new UnsupportedOperationException();
    }
}

