/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.filecache.FileCachedIndexInput;
import org.opensearch.index.store.remote.utils.BlobFetchRequest;
import org.opensearch.index.store.remote.utils.ConcurrentInvocationLinearizer;

public class TransferManager {
    private static final Logger logger = LogManager.getLogger(TransferManager.class);
    private final BlobContainer blobContainer;
    private final ConcurrentInvocationLinearizer<Path, IndexInput> invocationLinearizer;
    private final FileCache fileCache;

    public TransferManager(BlobContainer blobContainer, ExecutorService remoteStoreExecutorService, FileCache fileCache) {
        this.blobContainer = blobContainer;
        this.invocationLinearizer = new ConcurrentInvocationLinearizer(remoteStoreExecutorService);
        this.fileCache = fileCache;
    }

    public CompletableFuture<IndexInput> asyncFetchBlob(BlobFetchRequest blobFetchRequest) {
        return this.invocationLinearizer.linearize(blobFetchRequest.getFilePath(), p -> {
            try {
                return this.fetchBlob(blobFetchRequest);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).thenApply(IndexInput::clone);
    }

    private IndexInput fetchBlob(BlobFetchRequest blobFetchRequest) throws IOException {
        CachedIndexInput origin = this.fileCache.computeIfPresent(blobFetchRequest.getFilePath(), (path, cachedIndexInput) -> {
            if (cachedIndexInput.isClosed()) {
                try {
                    IndexInput luceneIndexInput = blobFetchRequest.getDirectory().openInput(blobFetchRequest.getFileName(), IOContext.READ);
                    return new FileCachedIndexInput(this.fileCache, blobFetchRequest.getFilePath(), luceneIndexInput);
                }
                catch (IOException ioe) {
                    logger.warn("Open index input " + blobFetchRequest.getFilePath() + " got error ", (Throwable)ioe);
                    return null;
                }
            }
            return cachedIndexInput;
        });
        if (Objects.isNull(origin)) {
            IndexInput downloaded = this.downloadBlockLocally(blobFetchRequest);
            FileCachedIndexInput newOrigin = new FileCachedIndexInput(this.fileCache, blobFetchRequest.getFilePath(), downloaded);
            this.fileCache.put(blobFetchRequest.getFilePath(), newOrigin);
            origin = newOrigin;
        }
        return origin;
    }

    private IndexInput downloadBlockLocally(BlobFetchRequest blobFetchRequest) throws IOException {
        try (InputStream snapshotFileInputStream = this.blobContainer.readBlob(blobFetchRequest.getBlobName(), blobFetchRequest.getPosition(), blobFetchRequest.getLength());
             OutputStream fileOutputStream = Files.newOutputStream(blobFetchRequest.getFilePath(), new OpenOption[0]);
             BufferedOutputStream localFileOutputStream = new BufferedOutputStream(fileOutputStream);){
            ((OutputStream)localFileOutputStream).write(snapshotFileInputStream.readAllBytes());
        }
        return blobFetchRequest.getDirectory().openInput(blobFetchRequest.getFileName(), IOContext.READ);
    }
}

