/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.io.Closeable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.StepListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.common.util.concurrent.ListenableFuture;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.recovery.DelayRecoveryException;
import org.opensearch.indices.recovery.FileChunkWriter;
import org.opensearch.indices.recovery.MultiChunkTransfer;
import org.opensearch.indices.replication.GetSegmentFilesRequest;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.SegmentFileTransferHandler;
import org.opensearch.indices.replication.common.CopyState;
import org.opensearch.indices.replication.common.ReplicationTimer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.Transports;

class SegmentReplicationSourceHandler {
    private final IndexShard shard;
    private final CopyState copyState;
    private final SegmentFileTransferHandler segmentFileTransferHandler;
    private final CancellableThreads cancellableThreads = new CancellableThreads();
    private final ListenableFuture<GetSegmentFilesResponse> future = new ListenableFuture();
    private final List<Closeable> resources = new CopyOnWriteArrayList<Closeable>();
    private final Logger logger;
    private final AtomicBoolean isReplicating = new AtomicBoolean();
    private final DiscoveryNode targetNode;
    private final String allocationId;
    private final FileChunkWriter writer;

    SegmentReplicationSourceHandler(DiscoveryNode targetNode, FileChunkWriter writer, ThreadPool threadPool, CopyState copyState, String allocationId, int fileChunkSizeInBytes, int maxConcurrentFileChunks) {
        this.targetNode = targetNode;
        this.shard = copyState.getShard();
        this.logger = Loggers.getLogger(SegmentReplicationSourceHandler.class, copyState.getShard().shardId(), "sending segments to " + targetNode.getName());
        this.segmentFileTransferHandler = new SegmentFileTransferHandler(copyState.getShard(), targetNode, writer, this.logger, threadPool, this.cancellableThreads, fileChunkSizeInBytes, maxConcurrentFileChunks);
        this.allocationId = allocationId;
        this.copyState = copyState;
        this.writer = writer;
    }

    public synchronized void sendFiles(GetSegmentFilesRequest request, ActionListener<GetSegmentFilesResponse> listener) {
        ReplicationTimer timer = new ReplicationTimer();
        if (!this.isReplicating.compareAndSet(false, true)) {
            throw new OpenSearchException("Replication to {} is already running.", this.shard.shardId());
        }
        this.future.addListener(listener, OpenSearchExecutors.newDirectExecutorService());
        Closeable releaseResources = () -> IOUtils.close(this.resources);
        try {
            timer.start();
            this.cancellableThreads.setOnCancel((reason, beforeCancelEx) -> {
                CancellableThreads.ExecutionCancelledException e = new CancellableThreads.ExecutionCancelledException("replication was canceled reason [" + reason + "]");
                if (beforeCancelEx != null) {
                    e.addSuppressed(beforeCancelEx);
                }
                IOUtils.closeWhileHandlingException(releaseResources, () -> this.future.onFailure(e));
                throw e;
            });
            Consumer<Exception> onFailure = e -> {
                assert (Transports.assertNotTransportThread(this + "[onFailure]"));
                IOUtils.closeWhileHandlingException(releaseResources, () -> this.future.onFailure((Exception)e));
                timer.stop();
                this.logger.trace("[replication id {}] Source node failed to send files to target node [{}], timing: {}", (Object)request.getReplicationId(), (Object)request.getTargetNode().getId(), (Object)timer.time());
            };
            IndexShardRoutingTable routingTable = this.shard.getReplicationGroup().getRoutingTable();
            ShardRouting targetShardRouting = routingTable.getByAllocationId(request.getTargetAllocationId());
            if (targetShardRouting == null) {
                this.logger.debug("delaying replication of {} as it is not listed as assigned to target node {}", (Object)this.shard.shardId(), (Object)this.targetNode);
                throw new DelayRecoveryException("source node does not have the shard listed in its state as allocated on the node");
            }
            StepListener<Void> sendFileStep = new StepListener<Void>();
            HashSet<String> storeFiles = new HashSet<String>(Arrays.asList(this.shard.store().directory().listAll()));
            StoreFileMetadata[] storeFileMetadata = (StoreFileMetadata[])request.getFilesToFetch().stream().filter(file -> storeFiles.contains(file.name())).toArray(StoreFileMetadata[]::new);
            MultiChunkTransfer<StoreFileMetadata, SegmentFileTransferHandler.FileChunk> transfer = this.segmentFileTransferHandler.createTransfer(this.shard.store(), storeFileMetadata, () -> 0, sendFileStep);
            this.resources.add(transfer);
            this.cancellableThreads.checkForCancel();
            transfer.start();
            sendFileStep.whenComplete(r -> {
                try {
                    this.future.onResponse(new GetSegmentFilesResponse(List.of(storeFileMetadata)));
                }
                finally {
                    IOUtils.close(this.resources);
                    timer.stop();
                    this.logger.trace("[replication id {}] Source node completed sending files to target node [{}], timing: {}", (Object)request.getReplicationId(), (Object)request.getTargetNode().getId(), (Object)timer.time());
                }
            }, onFailure);
        }
        catch (Exception e2) {
            IOUtils.closeWhileHandlingException(releaseResources, () -> this.future.onFailure(e2));
        }
    }

    public void cancel(String reason) {
        this.writer.cancel();
        this.cancellableThreads.cancel(reason);
    }

    CopyState getCopyState() {
        return this.copyState;
    }

    public boolean isReplicating() {
        return this.isReplicating.get();
    }

    public DiscoveryNode getTargetNode() {
        return this.targetNode;
    }

    public String getAllocationId() {
        return this.allocationId;
    }
}

