/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.opensearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;

public class RestFieldCapabilitiesAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_field_caps"), new RestHandler.Route(RestRequest.Method.POST, "/_field_caps"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_field_caps"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_field_caps")));
    }

    @Override
    public String getName() {
        return "field_capabilities_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        FieldCapabilitiesRequest fieldRequest = new FieldCapabilitiesRequest().fields(Strings.splitStringByCommaToArray(request.param("fields"))).indices(indices);
        fieldRequest.indicesOptions(IndicesOptions.fromRequest(request, fieldRequest.indicesOptions()));
        fieldRequest.includeUnmapped(request.paramAsBoolean("include_unmapped", false));
        request.withContentOrSourceParamParserOrNull(parser -> {
            if (parser != null) {
                fieldRequest.indexFilter(RestActions.getQueryContent("index_filter", parser));
            }
        });
        return channel -> client.fieldCaps(fieldRequest, new RestToXContentListener<FieldCapabilitiesResponse>((RestChannel)channel));
    }
}

