/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.search.aggregations.ParsedMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.adjacency.AdjacencyMatrix;

public class ParsedAdjacencyMatrix
extends ParsedMultiBucketAggregation<ParsedBucket>
implements AdjacencyMatrix {
    private Map<String, ParsedBucket> bucketMap;
    private static final ObjectParser<ParsedAdjacencyMatrix, Void> PARSER = new ObjectParser(ParsedAdjacencyMatrix.class.getSimpleName(), true, ParsedAdjacencyMatrix::new);

    @Override
    public String getType() {
        return "adjacency_matrix";
    }

    @Override
    public List<? extends AdjacencyMatrix.Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public ParsedBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, ParsedBucket>(this.buckets.size());
            for (ParsedBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    public static ParsedAdjacencyMatrix fromXContent(XContentParser parser, String name) throws IOException {
        ParsedAdjacencyMatrix aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedAdjacencyMatrix.declareMultiBucketAggregationFields(PARSER, parser -> ParsedBucket.fromXContent(parser), parser -> ParsedBucket.fromXContent(parser));
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements AdjacencyMatrix.Bucket {
        private String key;

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return ParsedBucket.parseXContent(parser, false, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.text();
            });
        }
    }
}

