/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.common.collect.Tuple;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.bucket.BucketUtils;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.MultiTermsValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.internal.SearchContext;

public class MultiTermsAggregationFactory
extends AggregatorFactory {
    private final List<Tuple<ValuesSourceConfig, IncludeExclude>> configs;
    private final List<DocValueFormat> formats;
    private final BucketOrder order;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final boolean showTermDocCountError;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(MultiTermsAggregationBuilder.REGISTRY_KEY, org.opensearch.common.collect.List.of(CoreValuesSourceType.BYTES, CoreValuesSourceType.IP), config -> {
            IncludeExclude.StringFilter filter = config.v2() == null ? null : ((IncludeExclude)config.v2()).convertToStringFilter(((ValuesSourceConfig)config.v1()).format());
            return MultiTermsAggregator.InternalValuesSourceFactory.bytesValuesSource(((ValuesSourceConfig)config.v1()).getValuesSource(), filter);
        }, true);
        builder.register(MultiTermsAggregationBuilder.REGISTRY_KEY, org.opensearch.common.collect.List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.DATE), config -> {
            ValuesSourceConfig valuesSourceConfig = (ValuesSourceConfig)config.v1();
            IncludeExclude includeExclude = (IncludeExclude)config.v2();
            ValuesSource.Numeric valuesSource = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
            IncludeExclude.LongFilter longFilter = null;
            if (valuesSource.isFloatingPoint()) {
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToDoubleFilter();
                }
                return MultiTermsAggregator.InternalValuesSourceFactory.doubleValueSource(valuesSource, longFilter);
            }
            if (includeExclude != null) {
                longFilter = includeExclude.convertToLongFilter(valuesSourceConfig.format());
            }
            return MultiTermsAggregator.InternalValuesSourceFactory.longValuesSource(valuesSource, longFilter);
        }, true);
        builder.registerUsage("multi_terms");
    }

    public MultiTermsAggregationFactory(String name, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, List<MultiTermsValuesSourceConfig> multiTermConfigs, BucketOrder order, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, boolean showTermDocCountError) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.configs = multiTermConfigs.stream().map(c -> new Tuple<ValuesSourceConfig, IncludeExclude>(ValuesSourceConfig.resolveUnregistered(queryShardContext, c.getUserValueTypeHint(), c.getFieldName(), c.getScript(), c.getMissing(), c.getTimeZone(), c.getFormat(), CoreValuesSourceType.BYTES), c.getIncludeExclude())).collect(Collectors.toList());
        this.formats = this.configs.stream().map(c -> ((ValuesSourceConfig)c.v1()).format()).collect(Collectors.toList());
        this.order = order;
        this.collectMode = collectMode;
        this.bucketCountThresholds = bucketCountThresholds;
        this.showTermDocCountError = showTermDocCountError;
    }

    @Override
    protected Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (!InternalOrder.isKeyOrder(this.order) && bucketCountThresholds.getShardSize() == TermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        bucketCountThresholds.ensureValidity();
        return new MultiTermsAggregator(this.name, this.factories, this.showTermDocCountError, this.configs.stream().map(config -> this.queryShardContext.getValuesSourceRegistry().getAggregator(MultiTermsAggregationBuilder.REGISTRY_KEY, (ValuesSourceConfig)config.v1()).build((Tuple<ValuesSourceConfig, IncludeExclude>)config)).collect(Collectors.toList()), this.configs.stream().map(c -> ((ValuesSourceConfig)c.v1()).format()).collect(Collectors.toList()), this.order, this.collectMode, bucketCountThresholds, searchContext, parent, cardinality, metadata);
    }

    public static interface InternalValuesSourceSupplier {
        public MultiTermsAggregator.InternalValuesSource build(Tuple<ValuesSourceConfig, IncludeExclude> var1);
    }
}

