/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationInitializationException;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.support.ArrayValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;

public abstract class ArrayValuesSourceAggregationBuilder<AB extends ArrayValuesSourceAggregationBuilder<AB>>
extends AbstractAggregationBuilder<AB> {
    public static final ParseField MULTIVALUE_MODE_FIELD = new ParseField("mode", new String[0]);
    private List<String> fields = Collections.emptyList();
    private ValueType userValueTypeHint = null;
    private String format = null;
    private Object missing = null;
    private Map<String, Object> missingMap = Collections.emptyMap();

    protected ArrayValuesSourceAggregationBuilder(String name) {
        super(name);
    }

    protected ArrayValuesSourceAggregationBuilder(ArrayValuesSourceAggregationBuilder<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.fields = new ArrayList<String>(clone.fields);
        this.userValueTypeHint = clone.userValueTypeHint;
        this.format = clone.format;
        this.missingMap = new HashMap<String, Object>(clone.missingMap);
        this.missing = clone.missing;
    }

    protected ArrayValuesSourceAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.fields = (ArrayList)in.readGenericValue();
        this.userValueTypeHint = in.readOptionalWriteable(ValueType::readFromStream);
        this.format = in.readOptionalString();
        this.missingMap = in.readMap();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.fields);
        out.writeOptionalWriteable(this.userValueTypeHint);
        out.writeOptionalString(this.format);
        out.writeMap(this.missingMap);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    public AB fields(List<String> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("[field] must not be null: [" + this.name + "]");
        }
        this.fields = fields;
        return (AB)this;
    }

    public List<String> fields() {
        return this.fields;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)this;
    }

    public String format() {
        return this.format;
    }

    public AB missingMap(Map<String, Object> missingMap) {
        if (missingMap == null) {
            throw new IllegalArgumentException("[missing] must not be null: [" + this.name + "]");
        }
        this.missingMap = missingMap;
        return (AB)this;
    }

    public Map<String, Object> missingMap() {
        return this.missingMap;
    }

    @Override
    protected final ArrayValuesSourceAggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        Map<String, ValuesSourceConfig> configs = this.resolveConfig(queryShardContext);
        ArrayValuesSourceAggregatorFactory factory = this.innerBuild(queryShardContext, configs, parent, subFactoriesBuilder);
        return factory;
    }

    protected Map<String, ValuesSourceConfig> resolveConfig(QueryShardContext queryShardContext) {
        HashMap<String, ValuesSourceConfig> configs = new HashMap<String, ValuesSourceConfig>();
        for (String field : this.fields) {
            ValuesSourceConfig config = ValuesSourceConfig.resolveUnregistered(queryShardContext, this.userValueTypeHint, field, null, this.missingMap.get(field), null, this.format, CoreValuesSourceType.BYTES);
            configs.put(field, config);
        }
        return configs;
    }

    protected abstract ArrayValuesSourceAggregatorFactory innerBuild(QueryShardContext var1, Map<String, ValuesSourceConfig> var2, AggregatorFactory var3, AggregatorFactories.Builder var4) throws IOException;

    @Override
    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.fields != null) {
            builder.field(AggregationBuilder.CommonFields.FIELDS.getPreferredName(), this.fields);
        }
        if (this.missing != null) {
            builder.field(AggregationBuilder.CommonFields.MISSING.getPreferredName(), this.missing);
        }
        if (this.format != null) {
            builder.field(AggregationBuilder.CommonFields.FORMAT.getPreferredName(), this.format);
        }
        if (this.userValueTypeHint != null) {
            builder.field(AggregationBuilder.CommonFields.VALUE_TYPE.getPreferredName(), this.userValueTypeHint.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields, this.format, this.missing, this.userValueTypeHint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArrayValuesSourceAggregationBuilder other = (ArrayValuesSourceAggregationBuilder)obj;
        return Objects.equals(this.fields, other.fields) && Objects.equals(this.format, other.format) && Objects.equals(this.missing, other.missing) && Objects.equals(this.userValueTypeHint, other.userValueTypeHint);
    }

    public static abstract class LeafOnly<AB extends ArrayValuesSourceAggregationBuilder<AB>>
    extends ArrayValuesSourceAggregationBuilder<AB> {
        protected LeafOnly(String name) {
            super(name);
        }

        protected LeafOnly(LeafOnly<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            super(clone, factoriesBuilder, metadata);
            if (factoriesBuilder.count() > 0) {
                throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
            }
        }

        protected LeafOnly(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
        }

        @Override
        public final AggregationBuilder.BucketCardinality bucketCardinality() {
            return AggregationBuilder.BucketCardinality.NONE;
        }
    }
}

