/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.opensearch.search.profile.query.CollectorResult;
import org.opensearch.search.profile.query.InternalProfileCollector;
import org.opensearch.search.profile.query.InternalProfileComponent;
import org.opensearch.search.profile.query.ProfileCollectorManager;
import org.opensearch.search.query.EarlyTerminatingListener;
import org.opensearch.search.query.ReduceableSearchResult;

public class InternalProfileCollectorManager
implements ProfileCollectorManager<InternalProfileCollector, ReduceableSearchResult>,
EarlyTerminatingListener {
    private final CollectorManager<? extends Collector, ReduceableSearchResult> manager;
    private final String reason;
    private final List<InternalProfileCollectorManager> children;
    private long time = 0L;

    public InternalProfileCollectorManager(CollectorManager<? extends Collector, ReduceableSearchResult> manager, String reason, List<InternalProfileCollectorManager> children) {
        this.manager = manager;
        this.reason = reason;
        this.children = children;
    }

    @Override
    public InternalProfileCollector newCollector() throws IOException {
        return new InternalProfileCollector(this.manager.newCollector(), this.reason, this.children);
    }

    @Override
    public ReduceableSearchResult reduce(Collection<InternalProfileCollector> collectors) throws IOException {
        ArrayList<Collector> subs = new ArrayList<Collector>();
        for (InternalProfileCollector collector : collectors) {
            subs.add(collector.getCollector());
            this.time += collector.getTime();
        }
        return this.manager.reduce(subs);
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public Collection<? extends InternalProfileComponent> children() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.manager.getClass().getSimpleName();
    }

    @Override
    public CollectorResult getCollectorTree() {
        return InternalProfileCollector.doGetCollectorTree(this);
    }

    @Override
    public void onEarlyTermination(int maxCountHits, boolean forcedTermination) {
        if (this.manager instanceof EarlyTerminatingListener) {
            ((EarlyTerminatingListener)((Object)this.manager)).onEarlyTermination(maxCountHits, forcedTermination);
        }
    }
}

