/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.opensearch.common.lucene.MinimumScoreCollector;
import org.opensearch.search.query.ReduceableSearchResult;

class MinimumCollectorManager
implements CollectorManager<MinimumScoreCollector, ReduceableSearchResult> {
    private final CollectorManager<? extends Collector, ReduceableSearchResult> manager;
    private final float minimumScore;

    MinimumCollectorManager(CollectorManager<? extends Collector, ReduceableSearchResult> manager, float minimumScore) {
        this.manager = manager;
        this.minimumScore = minimumScore;
    }

    @Override
    public MinimumScoreCollector newCollector() throws IOException {
        return new MinimumScoreCollector(this.manager.newCollector(), this.minimumScore);
    }

    @Override
    public ReduceableSearchResult reduce(Collection<MinimumScoreCollector> collectors) throws IOException {
        ArrayList<Collector> subCollectors = new ArrayList<Collector>();
        for (MinimumScoreCollector collector : collectors) {
            subCollectors.add(collector.getCollector());
        }
        return this.manager.reduce(subCollectors);
    }
}

