/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.web.management.internal;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.web.WebContainerService;
import org.apache.karaf.web.management.WebMBean;
import org.ops4j.pax.web.service.spi.model.info.WebApplicationInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;

public class WebMBeanImpl
extends StandardMBean
implements WebMBean {
    private WebContainerService webContainerService;

    public WebMBeanImpl() throws NotCompliantMBeanException {
        super(WebMBean.class);
    }

    public void setWebContainerService(WebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }

    @Override
    public TabularData getWebBundles() throws MBeanException {
        try {
            CompositeType webType = new CompositeType("Web Bundle", "An OSGi Web bundle", new String[]{"ID", "Context Name", "State", "Web-State", "Level", "Web-ContextPath", "Name"}, new String[]{"ID of the bundle", "Name of the context", "OSGi state of the bundle", "Web state of the bundle", "Start level of the bundle", "Web context path", "Name of the bundle"}, new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING});
            TabularType tableType = new TabularType("Web Bundles", "Table of web bundles", webType, new String[]{"ID", "Context Name"});
            TabularDataSupport table = new TabularDataSupport(tableType);
            for (WebApplicationInfo webBundle : this.webContainerService.list()) {
                String contextPath = webBundle.getContextPath();
                String contextName = webBundle.getName();
                String name = (String)webBundle.getBundle().getHeaders().get("Bundle-Name");
                name = name == null ? webBundle.getBundle().getSymbolicName() : name;
                name = name == null ? webBundle.getBundle().getLocation() : name;
                String version = (String)webBundle.getBundle().getHeaders().get("Bundle-Version");
                name = version != null ? name + " (" + version + ")" : name;
                long bundleId = webBundle.getBundle().getBundleId();
                int level = ((BundleStartLevel)webBundle.getBundle().adapt(BundleStartLevel.class)).getStartLevel();
                if (!contextPath.startsWith("/")) {
                    contextPath = "/" + contextPath;
                }
                try {
                    CompositeDataSupport data = new CompositeDataSupport(webType, new String[]{"ID", "Context Name", "State", "Web-State", "Level", "Web-ContextPath", "Name"}, new Object[]{webBundle.getBundle().getBundleId(), contextName, this.getStateString(webBundle.getBundle()), webBundle.getDeploymentState(), level, contextPath, name});
                    table.put(data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return table;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void install(String location, String contextPath) throws MBeanException {
        try {
            this.webContainerService.install(location, contextPath);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void uninstall(Long bundleId) throws MBeanException {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(bundleId);
            this.webContainerService.uninstall(list);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void uninstall(List<Long> bundleIds) throws MBeanException {
        try {
            this.webContainerService.uninstall(bundleIds);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void start(Long bundleId) throws MBeanException {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(bundleId);
            this.webContainerService.start(list);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void start(List<Long> bundleIds) throws MBeanException {
        try {
            this.webContainerService.start(bundleIds);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void stop(Long bundleId) throws MBeanException {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(bundleId);
            this.webContainerService.stop(list);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void stop(List<Long> bundleIds) throws MBeanException {
        try {
            this.webContainerService.stop(bundleIds);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    private String getStateString(Bundle bundle) {
        int state = bundle.getState();
        if (state == 32) {
            return "Active     ";
        }
        if (state == 2) {
            return "Installed  ";
        }
        if (state == 4) {
            return "Resolved   ";
        }
        if (state == 8) {
            return "Starting   ";
        }
        if (state == 16) {
            return "Stopping   ";
        }
        return "Unknown    ";
    }
}

