/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.OpenSearchException;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.rest.RestStatus;

public class GetAliasesResponse
implements StatusToXContentObject {
    private final RestStatus status;
    private final String error;
    private final OpenSearchException exception;
    private final Map<String, Set<AliasMetadata>> aliases;

    GetAliasesResponse(RestStatus status, String error, Map<String, Set<AliasMetadata>> aliases) {
        this.status = status;
        this.error = error;
        this.aliases = aliases;
        this.exception = null;
    }

    private GetAliasesResponse(RestStatus status, OpenSearchException exception) {
        this.status = status;
        this.error = null;
        this.aliases = Collections.emptyMap();
        this.exception = exception;
    }

    public RestStatus status() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public OpenSearchException getException() {
        return this.exception;
    }

    public Map<String, Set<AliasMetadata>> getAliases() {
        return this.aliases;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.status != RestStatus.OK) {
            builder.field("error", this.error);
            builder.field("status", this.status.getStatus());
        }
        for (Map.Entry<String, Set<AliasMetadata>> entry : this.aliases.entrySet()) {
            builder.startObject(entry.getKey());
            builder.startObject("aliases");
            for (AliasMetadata alias : entry.getValue()) {
                AliasMetadata.Builder.toXContent((AliasMetadata)alias, (XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static GetAliasesResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        HashMap<String, Set<AliasMetadata>> aliases = new HashMap<String, Set<AliasMetadata>>();
        String error = null;
        OpenSearchException exception = null;
        RestStatus status = RestStatus.OK;
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParser.Token token;
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) continue;
            String currentFieldName = parser.currentName();
            if ("status".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.FIELD_NAME) continue;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                status = RestStatus.fromCode((int)parser.intValue());
                continue;
            }
            if ("error".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.VALUE_STRING) {
                    error = parser.text();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    parser.nextToken();
                    exception = OpenSearchException.innerFromXContent((XContentParser)parser, (boolean)true);
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY) continue;
                parser.skipChildren();
                continue;
            }
            String indexName = parser.currentName();
            if (parser.nextToken() != XContentParser.Token.START_OBJECT) continue;
            Set<AliasMetadata> parseInside = GetAliasesResponse.parseAliases(parser);
            aliases.put(indexName, parseInside);
        }
        if (exception != null) {
            assert (error == null);
            assert (aliases.isEmpty());
            return new GetAliasesResponse(status, exception);
        }
        return new GetAliasesResponse(status, error, aliases);
    }

    private static Set<AliasMetadata> parseAliases(XContentParser parser) throws IOException {
        XContentParser.Token token;
        HashSet<AliasMetadata> aliases = new HashSet<AliasMetadata>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("aliases".equals(currentFieldName)) {
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        AliasMetadata fromXContent = AliasMetadata.Builder.fromXContent((XContentParser)parser);
                        aliases.add(fromXContent);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return aliases;
    }
}

