/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateTaskExecutor;
import org.opensearch.cluster.ClusterStateTaskListener;
import org.opensearch.cluster.NotClusterManagerException;
import org.opensearch.cluster.coordination.CoordinationMetadata;
import org.opensearch.cluster.coordination.CoordinationStateRejectedException;
import org.opensearch.cluster.coordination.Coordinator;
import org.opensearch.cluster.coordination.FailedToCommitClusterStateException;
import org.opensearch.cluster.coordination.Join;
import org.opensearch.cluster.coordination.JoinRequest;
import org.opensearch.cluster.coordination.JoinTaskExecutor;
import org.opensearch.cluster.coordination.StartJoinRequest;
import org.opensearch.cluster.coordination.ValidateJoinRequest;
import org.opensearch.cluster.decommission.NodeDecommissionedException;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.RerouteService;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.service.ClusterManagerService;
import org.opensearch.common.Priority;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.monitor.NodeHealthService;
import org.opensearch.monitor.StatusInfo;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponse;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class JoinHelper {
    private static final Logger logger = LogManager.getLogger(JoinHelper.class);
    public static final String JOIN_ACTION_NAME = "internal:cluster/coordination/join";
    public static final String VALIDATE_JOIN_ACTION_NAME = "internal:cluster/coordination/join/validate";
    public static final String START_JOIN_ACTION_NAME = "internal:cluster/coordination/start_join";
    public static final Setting<TimeValue> JOIN_TIMEOUT_SETTING = Setting.timeSetting("cluster.join.timeout", TimeValue.timeValueMillis((long)60000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope, Setting.Property.Deprecated);
    private final ClusterManagerService clusterManagerService;
    private final TransportService transportService;
    private volatile JoinTaskExecutor joinTaskExecutor;
    private final TimeValue joinTimeout;
    private final NodeHealthService nodeHealthService;
    private final Set<Tuple<DiscoveryNode, JoinRequest>> pendingOutgoingJoins = Collections.synchronizedSet(new HashSet());
    private final AtomicReference<FailedJoinAttempt> lastFailedJoinAttempt = new AtomicReference();
    private final Supplier<JoinTaskExecutor> joinTaskExecutorGenerator;
    private final Consumer<Boolean> nodeCommissioned;

    JoinHelper(Settings settings, AllocationService allocationService, ClusterManagerService clusterManagerService, TransportService transportService, final LongSupplier currentTermSupplier, Supplier<ClusterState> currentStateSupplier, BiConsumer<JoinRequest, JoinCallback> joinHandler, Function<StartJoinRequest, Join> joinLeaderInTerm, Collection<BiConsumer<DiscoveryNode, ClusterState>> joinValidators, RerouteService rerouteService, NodeHealthService nodeHealthService, Consumer<Boolean> nodeCommissioned) {
        this.clusterManagerService = clusterManagerService;
        this.transportService = transportService;
        this.nodeHealthService = nodeHealthService;
        this.joinTimeout = JOIN_TIMEOUT_SETTING.get(settings);
        this.nodeCommissioned = nodeCommissioned;
        this.joinTaskExecutorGenerator = () -> new JoinTaskExecutor(settings, allocationService, logger, rerouteService, transportService){
            private final long term;
            {
                super(settings, allocationService, logger, rerouteService, transportService);
                this.term = currentTermSupplier.getAsLong();
            }

            @Override
            public ClusterStateTaskExecutor.ClusterTasksResult<JoinTaskExecutor.Task> execute(ClusterState currentState, List<JoinTaskExecutor.Task> joiningTasks) throws Exception {
                if (currentState.term() > this.term) {
                    logger.trace("encountered higher term {} than current {}, there is a newer cluster-manager", (Object)currentState.term(), (Object)this.term);
                    throw new NotClusterManagerException("Higher term encountered (current: " + currentState.term() + " > used: " + this.term + "), there is a newer cluster-manager");
                }
                if (currentState.nodes().getClusterManagerNodeId() == null && joiningTasks.stream().anyMatch(JoinTaskExecutor.Task::isBecomeClusterManagerTask)) {
                    assert (currentState.term() < this.term) : "there should be at most one become cluster-manager task per election (= by term)";
                    CoordinationMetadata coordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).term(this.term).build();
                    Metadata metadata = Metadata.builder(currentState.metadata()).coordinationMetadata(coordinationMetadata).build();
                    currentState = ClusterState.builder(currentState).metadata(metadata).build();
                } else if (currentState.nodes().isLocalNodeElectedClusterManager()) assert (currentState.term() == this.term) : "term should be stable for the same cluster-manager";
                return super.execute(currentState, joiningTasks);
            }
        };
        transportService.registerRequestHandler(JOIN_ACTION_NAME, "generic", false, false, JoinRequest::new, (request, channel, task) -> joinHandler.accept((JoinRequest)request, this.transportJoinCallback(request, channel)));
        transportService.registerRequestHandler(START_JOIN_ACTION_NAME, "generic", false, false, StartJoinRequest::new, (request, channel, task) -> {
            DiscoveryNode destination = request.getSourceNode();
            this.sendJoinRequest(destination, currentTermSupplier.getAsLong(), Optional.of((Join)joinLeaderInTerm.apply((StartJoinRequest)request)));
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        });
        transportService.registerRequestHandler(VALIDATE_JOIN_ACTION_NAME, "generic", ValidateJoinRequest::new, (request, channel, task) -> {
            ClusterState localState = (ClusterState)currentStateSupplier.get();
            if (localState.metadata().clusterUUIDCommitted() && !localState.metadata().clusterUUID().equals(request.getState().metadata().clusterUUID())) {
                throw new CoordinationStateRejectedException("join validation on cluster state with a different cluster uuid " + request.getState().metadata().clusterUUID() + " than local cluster uuid " + localState.metadata().clusterUUID() + ", rejecting", new Object[0]);
            }
            joinValidators.forEach(action -> action.accept(transportService.getLocalNode(), request.getState()));
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        });
    }

    private JoinCallback transportJoinCallback(final TransportRequest request, final TransportChannel channel) {
        return new JoinCallback(){

            @Override
            public void onSuccess() {
                try {
                    channel.sendResponse(TransportResponse.Empty.INSTANCE);
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    channel.sendResponse(e);
                }
                catch (Exception inner) {
                    inner.addSuppressed(e);
                    logger.warn("failed to send back failure on join request", (Throwable)inner);
                }
            }

            public String toString() {
                return "JoinCallback{request=" + request + "}";
            }
        };
    }

    boolean isJoinPending() {
        return !this.pendingOutgoingJoins.isEmpty();
    }

    public void sendJoinRequest(DiscoveryNode destination, long term, Optional<Join> optionalJoin) {
        this.sendJoinRequest(destination, term, optionalJoin, () -> {});
    }

    void logLastFailedJoinAttempt() {
        FailedJoinAttempt attempt = this.lastFailedJoinAttempt.get();
        if (attempt != null) {
            attempt.logWarnWithTimestamp();
            this.lastFailedJoinAttempt.compareAndSet(attempt, null);
        }
    }

    public void sendJoinRequest(final DiscoveryNode destination, long term, Optional<Join> optionalJoin, final Runnable onCompletion) {
        assert (destination.isClusterManagerNode()) : "trying to join cluster-manager-ineligible " + destination;
        StatusInfo statusInfo = this.nodeHealthService.getHealth();
        if (statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
            logger.debug("dropping join request to [{}]: [{}]", (Object)destination, (Object)statusInfo.getInfo());
            return;
        }
        final JoinRequest joinRequest = new JoinRequest(this.transportService.getLocalNode(), term, optionalJoin);
        final Tuple dedupKey = Tuple.tuple((Object)destination, (Object)joinRequest);
        if (this.pendingOutgoingJoins.add((Tuple<DiscoveryNode, JoinRequest>)dedupKey)) {
            logger.debug("attempting to join {} with {}", (Object)destination, (Object)joinRequest);
            this.transportService.sendRequest(destination, JOIN_ACTION_NAME, (TransportRequest)joinRequest, TransportRequestOptions.EMPTY, new TransportResponseHandler<TransportResponse.Empty>(){

                @Override
                public TransportResponse.Empty read(StreamInput in) {
                    return TransportResponse.Empty.INSTANCE;
                }

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                    logger.debug("successfully joined {} with {}", (Object)destination, (Object)joinRequest);
                    JoinHelper.this.lastFailedJoinAttempt.set(null);
                    JoinHelper.this.nodeCommissioned.accept(true);
                    onCompletion.run();
                }

                @Override
                public void handleException(TransportException exp) {
                    JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                    logger.info(() -> new ParameterizedMessage("failed to join {} with {}", (Object)destination, (Object)joinRequest), (Throwable)exp);
                    FailedJoinAttempt attempt = new FailedJoinAttempt(destination, joinRequest, exp);
                    attempt.logNow();
                    JoinHelper.this.lastFailedJoinAttempt.set(attempt);
                    if (exp instanceof RemoteTransportException && exp.getCause() instanceof NodeDecommissionedException) {
                        logger.info("local node is decommissioned [{}]. Will not be able to join the cluster", (Object)exp.getCause().getMessage());
                        JoinHelper.this.nodeCommissioned.accept(false);
                    }
                    onCompletion.run();
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        } else {
            logger.debug("already attempting to join {} with request {}, not sending request", (Object)destination, (Object)joinRequest);
        }
    }

    public void sendStartJoinRequest(final StartJoinRequest startJoinRequest, final DiscoveryNode destination) {
        assert (startJoinRequest.getSourceNode().isClusterManagerNode()) : "sending start-join request for cluster-manager-ineligible " + startJoinRequest.getSourceNode();
        this.transportService.sendRequest(destination, START_JOIN_ACTION_NAME, startJoinRequest, new TransportResponseHandler<TransportResponse.Empty>(){

            @Override
            public TransportResponse.Empty read(StreamInput in) {
                return TransportResponse.Empty.INSTANCE;
            }

            @Override
            public void handleResponse(TransportResponse.Empty response) {
                logger.debug("successful response to {} from {}", (Object)startJoinRequest, (Object)destination);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.debug((Message)new ParameterizedMessage("failure in response to {} from {}", (Object)startJoinRequest, (Object)destination), (Throwable)exp);
            }

            @Override
            public String executor() {
                return "same";
            }
        });
    }

    public void sendValidateJoinRequest(DiscoveryNode node, ClusterState state, ActionListener<TransportResponse.Empty> listener) {
        this.transportService.sendRequest(node, VALIDATE_JOIN_ACTION_NAME, new ValidateJoinRequest(state), new ActionListenerResponseHandler<TransportResponse.Empty>(listener, i -> TransportResponse.Empty.INSTANCE, "generic"));
    }

    static class FailedJoinAttempt {
        private final DiscoveryNode destination;
        private final JoinRequest joinRequest;
        private final TransportException exception;
        private final long timestamp;

        FailedJoinAttempt(DiscoveryNode destination, JoinRequest joinRequest, TransportException exception) {
            this.destination = destination;
            this.joinRequest = joinRequest;
            this.exception = exception;
            this.timestamp = System.nanoTime();
        }

        void logNow() {
            logger.log(FailedJoinAttempt.getLogLevel(this.exception), () -> new ParameterizedMessage("failed to join {} with {}", (Object)this.destination, (Object)this.joinRequest), (Throwable)this.exception);
        }

        static Level getLogLevel(TransportException e) {
            Throwable cause = e.unwrapCause();
            if (cause instanceof CoordinationStateRejectedException || cause instanceof FailedToCommitClusterStateException || cause instanceof NotClusterManagerException) {
                return Level.DEBUG;
            }
            return Level.INFO;
        }

        void logWarnWithTimestamp() {
            logger.warn(() -> new ParameterizedMessage("last failed join attempt was {} ago, failed to join {} with {}", new Object[]{TimeValue.timeValueMillis((long)TimeValue.nsecToMSec((long)(System.nanoTime() - this.timestamp))), this.destination, this.joinRequest}), (Throwable)this.exception);
        }
    }

    public static interface JoinCallback {
        public void onSuccess();

        public void onFailure(Exception var1);
    }

    class CandidateJoinAccumulator
    implements JoinAccumulator {
        private final Map<DiscoveryNode, JoinCallback> joinRequestAccumulator = new HashMap<DiscoveryNode, JoinCallback>();
        boolean closed;

        CandidateJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, JoinCallback joinCallback) {
            assert (!this.closed) : "CandidateJoinAccumulator closed";
            JoinCallback prev = this.joinRequestAccumulator.put(sender, joinCallback);
            if (prev != null) {
                prev.onFailure(new CoordinationStateRejectedException("received a newer join from " + sender, new Object[0]));
            }
        }

        @Override
        public void close(Coordinator.Mode newMode) {
            assert (!this.closed) : "CandidateJoinAccumulator closed";
            this.closed = true;
            if (newMode == Coordinator.Mode.LEADER) {
                LinkedHashMap<JoinTaskExecutor.Task, ClusterStateTaskListener> pendingAsTasks = new LinkedHashMap<JoinTaskExecutor.Task, ClusterStateTaskListener>();
                this.joinRequestAccumulator.forEach((key, value) -> {
                    JoinTaskExecutor.Task task = new JoinTaskExecutor.Task((DiscoveryNode)key, "elect leader");
                    pendingAsTasks.put(task, new JoinTaskListener(task, (JoinCallback)value));
                });
                String stateUpdateSource = "elected-as-cluster-manager ([" + pendingAsTasks.size() + "] nodes joined)";
                pendingAsTasks.put(JoinTaskExecutor.newBecomeClusterManagerTask(), (source, e) -> {});
                pendingAsTasks.put(JoinTaskExecutor.newFinishElectionTask(), (source, e) -> {});
                JoinHelper.this.joinTaskExecutor = JoinHelper.this.joinTaskExecutorGenerator.get();
                JoinHelper.this.clusterManagerService.submitStateUpdateTasks(stateUpdateSource, pendingAsTasks, ClusterStateTaskConfig.build(Priority.URGENT), JoinHelper.this.joinTaskExecutor);
            } else {
                assert (newMode == Coordinator.Mode.FOLLOWER) : newMode;
                JoinHelper.this.joinTaskExecutor = null;
                this.joinRequestAccumulator.values().forEach(joinCallback -> joinCallback.onFailure(new CoordinationStateRejectedException("became follower", new Object[0])));
            }
        }

        public String toString() {
            return "CandidateJoinAccumulator{" + this.joinRequestAccumulator.keySet() + ", closed=" + this.closed + "}";
        }
    }

    static class FollowerJoinAccumulator
    implements JoinAccumulator {
        FollowerJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, JoinCallback joinCallback) {
            joinCallback.onFailure(new CoordinationStateRejectedException("join target is a follower", new Object[0]));
        }

        public String toString() {
            return "FollowerJoinAccumulator";
        }
    }

    static class InitialJoinAccumulator
    implements JoinAccumulator {
        InitialJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, JoinCallback joinCallback) {
            assert (false) : "unexpected join from " + sender + " during initialisation";
            joinCallback.onFailure(new CoordinationStateRejectedException("join target is not initialised yet", new Object[0]));
        }

        public String toString() {
            return "InitialJoinAccumulator";
        }
    }

    class LeaderJoinAccumulator
    implements JoinAccumulator {
        LeaderJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, JoinCallback joinCallback) {
            JoinTaskExecutor.Task task = new JoinTaskExecutor.Task(sender, "join existing leader");
            assert (JoinHelper.this.joinTaskExecutor != null);
            JoinHelper.this.clusterManagerService.submitStateUpdateTask("node-join", task, ClusterStateTaskConfig.build(Priority.URGENT), JoinHelper.this.joinTaskExecutor, new JoinTaskListener(task, joinCallback));
        }

        public String toString() {
            return "LeaderJoinAccumulator";
        }
    }

    static interface JoinAccumulator {
        public void handleJoinRequest(DiscoveryNode var1, JoinCallback var2);

        default public void close(Coordinator.Mode newMode) {
        }
    }

    static class JoinTaskListener
    implements ClusterStateTaskListener {
        private final JoinTaskExecutor.Task task;
        private final JoinCallback joinCallback;

        JoinTaskListener(JoinTaskExecutor.Task task, JoinCallback joinCallback) {
            this.task = task;
            this.joinCallback = joinCallback;
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.joinCallback.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            this.joinCallback.onSuccess();
        }

        public String toString() {
            return "JoinTaskListener{task=" + this.task + "}";
        }
    }
}

