/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.decommission;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opensearch.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import org.opensearch.action.admin.cluster.configuration.VotingConfigExclusionsHelper;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.coordination.CoordinationMetadata;
import org.opensearch.cluster.decommission.DecommissionAttribute;
import org.opensearch.cluster.decommission.DecommissionAttributeMetadata;
import org.opensearch.cluster.decommission.DecommissionStatus;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Strings;
import org.opensearch.common.unit.TimeValue;

public class DecommissionHelper {
    static ClusterState registerDecommissionAttributeInClusterState(ClusterState currentState, DecommissionAttribute decommissionAttribute, String requestID) {
        DecommissionAttributeMetadata decommissionAttributeMetadata = new DecommissionAttributeMetadata(decommissionAttribute, requestID);
        return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).decommissionAttributeMetadata(decommissionAttributeMetadata)).build();
    }

    static ClusterState deleteDecommissionAttributeInClusterState(ClusterState currentState) {
        Metadata metadata = currentState.metadata();
        Metadata.Builder mdBuilder = Metadata.builder(metadata);
        mdBuilder.removeCustom("decommissionedAttribute");
        return ClusterState.builder(currentState).metadata(mdBuilder).build();
    }

    static ClusterState addVotingConfigExclusionsForNodesToBeDecommissioned(ClusterState currentState, Set<String> nodeIdsToBeExcluded, TimeValue decommissionActionTimeout, int maxVotingConfigExclusions) {
        AddVotingConfigExclusionsRequest request = new AddVotingConfigExclusionsRequest(Strings.EMPTY_ARRAY, (String[])nodeIdsToBeExcluded.toArray(String[]::new), Strings.EMPTY_ARRAY, decommissionActionTimeout);
        Set<CoordinationMetadata.VotingConfigExclusion> resolvedExclusion = VotingConfigExclusionsHelper.resolveVotingConfigExclusionsAndCheckMaximum(request, currentState, maxVotingConfigExclusions);
        return VotingConfigExclusionsHelper.addExclusionAndGetState(currentState, resolvedExclusion, maxVotingConfigExclusions);
    }

    static Set<DiscoveryNode> filterNodesWithDecommissionAttribute(ClusterState clusterState, DecommissionAttribute decommissionAttribute, boolean onlyClusterManagerNodes) {
        Iterator<DiscoveryNode> nodesIter;
        HashSet<DiscoveryNode> nodesWithDecommissionAttribute = new HashSet<DiscoveryNode>();
        Iterator<DiscoveryNode> iterator = nodesIter = onlyClusterManagerNodes ? clusterState.nodes().getClusterManagerNodes().valuesIt() : clusterState.nodes().getNodes().valuesIt();
        while (nodesIter.hasNext()) {
            DiscoveryNode node = nodesIter.next();
            if (!DecommissionHelper.nodeHasDecommissionedAttribute(node, decommissionAttribute)) continue;
            nodesWithDecommissionAttribute.add(node);
        }
        return nodesWithDecommissionAttribute;
    }

    public static boolean nodeHasDecommissionedAttribute(DiscoveryNode discoveryNode, DecommissionAttribute decommissionAttribute) {
        String nodeAttributeValue = discoveryNode.getAttributes().get(decommissionAttribute.attributeName());
        return nodeAttributeValue != null && nodeAttributeValue.equals(decommissionAttribute.attributeValue());
    }

    public static boolean nodeCommissioned(DiscoveryNode discoveryNode, Metadata metadata) {
        DecommissionAttributeMetadata decommissionAttributeMetadata = metadata.decommissionAttributeMetadata();
        if (decommissionAttributeMetadata != null) {
            DecommissionAttribute decommissionAttribute = decommissionAttributeMetadata.decommissionAttribute();
            DecommissionStatus status = decommissionAttributeMetadata.status();
            if (decommissionAttribute != null && status != null && DecommissionHelper.nodeHasDecommissionedAttribute(discoveryNode, decommissionAttribute) && (status.equals((Object)DecommissionStatus.IN_PROGRESS) || status.equals((Object)DecommissionStatus.SUCCESSFUL) || status.equals((Object)DecommissionStatus.DRAINING))) {
                return false;
            }
        }
        return true;
    }
}

