/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.util.ThreadInterruptedException;
import org.opensearch.OpenSearchException;
import org.opensearch.common.Nullable;
import org.opensearch.common.SetOnce;
import org.opensearch.common.io.stream.StreamInput;

public class CancellableThreads {
    private final Set<Thread> threads = new HashSet<Thread>();
    private volatile boolean cancelled = false;
    private final SetOnce<OnCancel> onCancel = new SetOnce();
    private String reason;

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public void checkForCancel() {
        this.checkForCancel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForCancel(Exception beforeCancelException) {
        if (this.isCancelled()) {
            OnCancel onCancel;
            String reason;
            CancellableThreads cancellableThreads = this;
            synchronized (cancellableThreads) {
                reason = this.reason;
                onCancel = (OnCancel)this.onCancel.get();
            }
            if (onCancel != null) {
                onCancel.onCancel(reason, beforeCancelException);
            }
            ExecutionCancelledException cancelExp = new ExecutionCancelledException("operation was cancelled reason [" + reason + "]");
            if (beforeCancelException != null) {
                cancelExp.addSuppressed(beforeCancelException);
            }
            throw cancelExp;
        }
    }

    private synchronized boolean add() {
        this.checkForCancel();
        this.threads.add(Thread.currentThread());
        return Thread.interrupted();
    }

    public void execute(Interruptible interruptible) {
        try {
            this.executeIO(interruptible);
        }
        catch (IOException e) {
            assert (false) : "the passed interruptible can not result in an IOException";
            throw new RuntimeException("unexpected IO exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeIO(IOInterruptible interruptible) throws IOException {
        boolean wasInterrupted = this.add();
        boolean cancelledByExternalInterrupt = false;
        RuntimeException runtimeException = null;
        IOException ioException = null;
        try {
            interruptible.run();
        }
        catch (InterruptedException | ThreadInterruptedException e) {
            assert (this.cancelled) : "Interruption via Thread#interrupt() is unsupported. Use CancellableThreads#cancel() instead";
            cancelledByExternalInterrupt = !this.cancelled;
        }
        catch (RuntimeException t) {
            runtimeException = t;
        }
        catch (IOException e) {
            ioException = e;
        }
        finally {
            this.remove();
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        } else {
            Thread.interrupted();
        }
        this.checkForCancel(ioException != null ? ioException : runtimeException);
        if (ioException != null) {
            throw ioException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        if (cancelledByExternalInterrupt) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interruption via Thread#interrupt() is unsupported. Use CancellableThreads#cancel() instead");
        }
    }

    private synchronized void remove() {
        this.threads.remove(Thread.currentThread());
    }

    public synchronized void cancel(String reason) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.reason = reason;
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
        this.threads.clear();
    }

    public synchronized void setOnCancel(OnCancel onCancel) {
        this.onCancel.set((Object)onCancel);
    }

    @FunctionalInterface
    public static interface OnCancel {
        public void onCancel(String var1, @Nullable Exception var2);
    }

    public static class ExecutionCancelledException
    extends OpenSearchException {
        public ExecutionCancelledException(String msg) {
            super(msg, new Object[0]);
        }

        public ExecutionCancelledException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static interface IOInterruptible {
        public void run() throws IOException, InterruptedException;
    }

    public static interface Interruptible
    extends IOInterruptible {
        @Override
        public void run() throws InterruptedException;
    }
}

