/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.support.TransportAction;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.transport.TransportRequest;

public class RegisterTransportActionsRequest
extends TransportRequest {
    private String uniqueId;
    private Map<String, Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>>> transportActions;

    public RegisterTransportActionsRequest(String uniqueId, Map<String, Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>>> transportActions) {
        this.uniqueId = uniqueId;
        this.transportActions = new HashMap<String, Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>>>(transportActions);
    }

    public RegisterTransportActionsRequest(StreamInput in) throws IOException {
        super(in);
        this.uniqueId = in.readString();
        HashMap<String, Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>>> actions = new HashMap<String, Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>>>();
        int actionCount = in.readVInt();
        for (int i = 0; i < actionCount; ++i) {
            try {
                String actionName = in.readString();
                Class<?> transportAction = Class.forName(in.readString());
                actions.put(actionName, transportAction);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not read transport action");
            }
        }
        this.transportActions = actions;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Map<String, Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>>> getTransportActions() {
        return this.transportActions;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.uniqueId);
        out.writeVInt(this.transportActions.size());
        for (Map.Entry<String, Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>>> action : this.transportActions.entrySet()) {
            out.writeString(action.getKey());
            out.writeString(action.getValue().getName());
        }
    }

    public String toString() {
        return "TransportActionsRequest{uniqueId=" + this.uniqueId + ", actions=" + this.transportActions + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegisterTransportActionsRequest that = (RegisterTransportActionsRequest)obj;
        return Objects.equals(this.uniqueId, that.uniqueId) && Objects.equals(this.transportActions, that.transportActions);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.transportActions);
    }
}

