/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opensearch.common.Nullable;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.lookup.SourceLookup;

public abstract class ArraySourceValueFetcher
implements ValueFetcher {
    private final Set<String> sourcePaths;
    @Nullable
    private final Object nullValue;

    public ArraySourceValueFetcher(String fieldName, QueryShardContext context) {
        this(fieldName, context, null);
    }

    public ArraySourceValueFetcher(String fieldName, QueryShardContext context, Object nullValue) {
        this.sourcePaths = context.sourcePath(fieldName);
        this.nullValue = nullValue;
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String path : this.sourcePaths) {
            Object sourceValue = lookup.extractValue(path, this.nullValue);
            if (sourceValue == null) {
                return org.opensearch.common.collect.List.of();
            }
            values.addAll((List)this.parseSourceValue(sourceValue));
        }
        return values;
    }

    protected abstract Object parseSourceValue(Object var1);
}

