/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.stats;

import java.io.IOException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.ShardIndexingPressureTracker;

public class IndexingPressurePerShardStats
implements Writeable,
ToXContentFragment {
    private final String shardId;
    private final long totalCombinedCoordinatingAndPrimaryBytes;
    private final long totalCoordinatingBytes;
    private final long totalPrimaryBytes;
    private final long totalReplicaBytes;
    private final long currentCombinedCoordinatingAndPrimaryBytes;
    private final long currentCoordinatingBytes;
    private final long currentPrimaryBytes;
    private final long currentReplicaBytes;
    private final long totalCoordinatingCount;
    private final long totalPrimaryCount;
    private final long totalReplicaCount;
    private final long coordinatingRejections;
    private final long coordinatingNodeLimitsBreachedRejections;
    private final long coordinatingLastSuccessfulRequestLimitsBreachedRejections;
    private final long coordinatingThroughputDegradationLimitsBreachedRejections;
    private final long primaryRejections;
    private final long primaryNodeLimitsBreachedRejections;
    private final long primaryLastSuccessfulRequestLimitsBreachedRejections;
    private final long primaryThroughputDegradationLimitsBreachedRejections;
    private final long replicaRejections;
    private final long replicaNodeLimitsBreachedRejections;
    private final long replicaLastSuccessfulRequestLimitsBreachedRejections;
    private final long replicaThroughputDegradationLimitsBreachedRejections;
    private final long coordinatingTimeInMillis;
    private final long primaryTimeInMillis;
    private final long replicaTimeInMillis;
    private final long coordinatingLastSuccessfulRequestTimestampInMillis;
    private final long primaryLastSuccessfulRequestTimestampInMillis;
    private final long replicaLastSuccessfulRequestTimestampInMillis;
    private final long currentPrimaryAndCoordinatingLimits;
    private final long currentReplicaLimits;
    private final boolean shardIndexingPressureEnforced;
    private static final String COORDINATING = "coordinating";
    private static final String COORDINATING_IN_BYTES = "coordinating_in_bytes";
    private static final String COORDINATING_COUNT = "coordinating_count";
    private static final String PRIMARY = "primary";
    private static final String PRIMARY_IN_BYTES = "primary_in_bytes";
    private static final String PRIMARY_COUNT = "primary_count";
    private static final String REPLICA = "replica";
    private static final String REPLICA_IN_BYTES = "replica_in_bytes";
    private static final String REPLICA_COUNT = "replica_count";
    private static final String COORDINATING_REJECTIONS = "coordinating_rejections";
    private static final String PRIMARY_REJECTIONS = "primary_rejections";
    private static final String REPLICA_REJECTIONS = "replica_rejections";
    private static final String BREAKUP_NODE_LIMITS = "node_limits";
    private static final String BREAKUP_NO_SUCCESSFUL_REQUEST_LIMITS = "no_successful_request_limits";
    private static final String BREAKUP_THROUGHPUT_DEGRADATION_LIMIT = "throughput_degradation_limits";
    private static final String COORDINATING_TIME_IN_MILLIS = "coordinating_time_in_millis";
    private static final String PRIMARY_TIME_IN_MILLIS = "primary_time_in_millis";
    private static final String REPLICA_TIME_IN_MILLIS = "replica_time_in_millis";
    private static final String COORDINATING_LAST_SUCCESSFUL_REQUEST_TIMESTAMP_IN_MILLIS = "coordinating_last_successful_request_timestamp_in_millis";
    private static final String PRIMARY_LAST_SUCCESSFUL_REQUEST_TIMESTAMP_IN_MILLIS = "primary_last_successful_request_timestamp_in_millis";
    private static final String REPLICA_LAST_SUCCESSFUL_REQUEST_TIMESTAMP_IN_MILLIS = "replica_last_successful_request_timestamp_in_millis";
    private static final String CURRENT_COORDINATING_AND_PRIMARY_LIMITS_IN_BYTES = "current_coordinating_and_primary_limits_in_bytes";
    private static final String CURRENT_REPLICA_LIMITS_IN_BYTES = "current_replica_limits_in_bytes";
    private static final String CURRENT_COORDINATING_AND_PRIMARY_IN_BYTES = "current_coordinating_and_primary_bytes";
    private static final String CURRENT_REPLICA_IN_BYTES = "current_replica_bytes";

    public IndexingPressurePerShardStats(StreamInput in) throws IOException {
        this.shardId = in.readString();
        this.shardIndexingPressureEnforced = in.readBoolean();
        this.totalCombinedCoordinatingAndPrimaryBytes = in.readVLong();
        this.totalCoordinatingBytes = in.readVLong();
        this.totalPrimaryBytes = in.readVLong();
        this.totalReplicaBytes = in.readVLong();
        this.currentCombinedCoordinatingAndPrimaryBytes = in.readVLong();
        this.currentCoordinatingBytes = in.readVLong();
        this.currentPrimaryBytes = in.readVLong();
        this.currentReplicaBytes = in.readVLong();
        this.totalCoordinatingCount = in.readVLong();
        this.totalPrimaryCount = in.readVLong();
        this.totalReplicaCount = in.readVLong();
        this.coordinatingRejections = in.readVLong();
        this.coordinatingNodeLimitsBreachedRejections = in.readVLong();
        this.coordinatingLastSuccessfulRequestLimitsBreachedRejections = in.readVLong();
        this.coordinatingThroughputDegradationLimitsBreachedRejections = in.readVLong();
        this.primaryRejections = in.readVLong();
        this.primaryNodeLimitsBreachedRejections = in.readVLong();
        this.primaryLastSuccessfulRequestLimitsBreachedRejections = in.readVLong();
        this.primaryThroughputDegradationLimitsBreachedRejections = in.readVLong();
        this.replicaRejections = in.readVLong();
        this.replicaNodeLimitsBreachedRejections = in.readVLong();
        this.replicaLastSuccessfulRequestLimitsBreachedRejections = in.readVLong();
        this.replicaThroughputDegradationLimitsBreachedRejections = in.readVLong();
        this.coordinatingTimeInMillis = in.readVLong();
        this.primaryTimeInMillis = in.readVLong();
        this.replicaTimeInMillis = in.readVLong();
        this.coordinatingLastSuccessfulRequestTimestampInMillis = in.readVLong();
        this.primaryLastSuccessfulRequestTimestampInMillis = in.readVLong();
        this.replicaLastSuccessfulRequestTimestampInMillis = in.readVLong();
        this.currentPrimaryAndCoordinatingLimits = in.readVLong();
        this.currentReplicaLimits = in.readVLong();
    }

    public IndexingPressurePerShardStats(ShardIndexingPressureTracker shardIndexingPressureTracker, boolean shardIndexingPressureEnforced) {
        this.shardId = shardIndexingPressureTracker.getShardId().toString();
        this.shardIndexingPressureEnforced = shardIndexingPressureEnforced;
        this.totalCombinedCoordinatingAndPrimaryBytes = shardIndexingPressureTracker.getCommonOperationTracker().getTotalCombinedCoordinatingAndPrimaryBytes();
        this.totalCoordinatingBytes = shardIndexingPressureTracker.getCoordinatingOperationTracker().getStatsTracker().getTotalBytes();
        this.totalPrimaryBytes = shardIndexingPressureTracker.getPrimaryOperationTracker().getStatsTracker().getTotalBytes();
        this.totalReplicaBytes = shardIndexingPressureTracker.getReplicaOperationTracker().getStatsTracker().getTotalBytes();
        this.currentCombinedCoordinatingAndPrimaryBytes = shardIndexingPressureTracker.getCommonOperationTracker().getCurrentCombinedCoordinatingAndPrimaryBytes();
        this.currentCoordinatingBytes = shardIndexingPressureTracker.getCoordinatingOperationTracker().getStatsTracker().getCurrentBytes();
        this.currentPrimaryBytes = shardIndexingPressureTracker.getPrimaryOperationTracker().getStatsTracker().getCurrentBytes();
        this.currentReplicaBytes = shardIndexingPressureTracker.getReplicaOperationTracker().getStatsTracker().getCurrentBytes();
        this.totalCoordinatingCount = shardIndexingPressureTracker.getCoordinatingOperationTracker().getStatsTracker().getRequestCount();
        this.totalPrimaryCount = shardIndexingPressureTracker.getPrimaryOperationTracker().getStatsTracker().getRequestCount();
        this.totalReplicaCount = shardIndexingPressureTracker.getReplicaOperationTracker().getStatsTracker().getRequestCount();
        this.coordinatingRejections = shardIndexingPressureTracker.getCoordinatingOperationTracker().getRejectionTracker().getTotalRejections();
        this.coordinatingNodeLimitsBreachedRejections = shardIndexingPressureTracker.getCoordinatingOperationTracker().getRejectionTracker().getNodeLimitsBreachedRejections();
        this.coordinatingLastSuccessfulRequestLimitsBreachedRejections = shardIndexingPressureTracker.getCoordinatingOperationTracker().getRejectionTracker().getLastSuccessfulRequestLimitsBreachedRejections();
        this.coordinatingThroughputDegradationLimitsBreachedRejections = shardIndexingPressureTracker.getCoordinatingOperationTracker().getRejectionTracker().getThroughputDegradationLimitsBreachedRejections();
        this.primaryRejections = shardIndexingPressureTracker.getPrimaryOperationTracker().getRejectionTracker().getTotalRejections();
        this.primaryNodeLimitsBreachedRejections = shardIndexingPressureTracker.getPrimaryOperationTracker().getRejectionTracker().getNodeLimitsBreachedRejections();
        this.primaryLastSuccessfulRequestLimitsBreachedRejections = shardIndexingPressureTracker.getPrimaryOperationTracker().getRejectionTracker().getLastSuccessfulRequestLimitsBreachedRejections();
        this.primaryThroughputDegradationLimitsBreachedRejections = shardIndexingPressureTracker.getPrimaryOperationTracker().getRejectionTracker().getThroughputDegradationLimitsBreachedRejections();
        this.replicaRejections = shardIndexingPressureTracker.getReplicaOperationTracker().getRejectionTracker().getTotalRejections();
        this.replicaNodeLimitsBreachedRejections = shardIndexingPressureTracker.getReplicaOperationTracker().getRejectionTracker().getNodeLimitsBreachedRejections();
        this.replicaLastSuccessfulRequestLimitsBreachedRejections = shardIndexingPressureTracker.getReplicaOperationTracker().getRejectionTracker().getLastSuccessfulRequestLimitsBreachedRejections();
        this.replicaThroughputDegradationLimitsBreachedRejections = shardIndexingPressureTracker.getReplicaOperationTracker().getRejectionTracker().getThroughputDegradationLimitsBreachedRejections();
        this.coordinatingTimeInMillis = shardIndexingPressureTracker.getCoordinatingOperationTracker().getPerformanceTracker().getLatencyInMillis();
        this.primaryTimeInMillis = shardIndexingPressureTracker.getPrimaryOperationTracker().getPerformanceTracker().getLatencyInMillis();
        this.replicaTimeInMillis = shardIndexingPressureTracker.getReplicaOperationTracker().getPerformanceTracker().getLatencyInMillis();
        this.coordinatingLastSuccessfulRequestTimestampInMillis = shardIndexingPressureTracker.getCoordinatingOperationTracker().getPerformanceTracker().getLastSuccessfulRequestTimestamp();
        this.primaryLastSuccessfulRequestTimestampInMillis = shardIndexingPressureTracker.getPrimaryOperationTracker().getPerformanceTracker().getLastSuccessfulRequestTimestamp();
        this.replicaLastSuccessfulRequestTimestampInMillis = shardIndexingPressureTracker.getReplicaOperationTracker().getPerformanceTracker().getLastSuccessfulRequestTimestamp();
        this.currentPrimaryAndCoordinatingLimits = shardIndexingPressureTracker.getPrimaryAndCoordinatingLimits();
        this.currentReplicaLimits = shardIndexingPressureTracker.getReplicaLimits();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.shardId);
        out.writeBoolean(this.shardIndexingPressureEnforced);
        out.writeVLong(this.totalCombinedCoordinatingAndPrimaryBytes);
        out.writeVLong(this.totalCoordinatingBytes);
        out.writeVLong(this.totalPrimaryBytes);
        out.writeVLong(this.totalReplicaBytes);
        out.writeVLong(this.currentCombinedCoordinatingAndPrimaryBytes);
        out.writeVLong(this.currentCoordinatingBytes);
        out.writeVLong(this.currentPrimaryBytes);
        out.writeVLong(this.currentReplicaBytes);
        out.writeVLong(this.totalCoordinatingCount);
        out.writeVLong(this.totalPrimaryCount);
        out.writeVLong(this.totalReplicaCount);
        out.writeVLong(this.coordinatingRejections);
        out.writeVLong(this.coordinatingNodeLimitsBreachedRejections);
        out.writeVLong(this.coordinatingLastSuccessfulRequestLimitsBreachedRejections);
        out.writeVLong(this.coordinatingThroughputDegradationLimitsBreachedRejections);
        out.writeVLong(this.primaryRejections);
        out.writeVLong(this.primaryNodeLimitsBreachedRejections);
        out.writeVLong(this.primaryLastSuccessfulRequestLimitsBreachedRejections);
        out.writeVLong(this.primaryThroughputDegradationLimitsBreachedRejections);
        out.writeVLong(this.replicaRejections);
        out.writeVLong(this.replicaNodeLimitsBreachedRejections);
        out.writeVLong(this.replicaLastSuccessfulRequestLimitsBreachedRejections);
        out.writeVLong(this.replicaThroughputDegradationLimitsBreachedRejections);
        out.writeVLong(this.coordinatingTimeInMillis);
        out.writeVLong(this.primaryTimeInMillis);
        out.writeVLong(this.replicaTimeInMillis);
        out.writeVLong(this.coordinatingLastSuccessfulRequestTimestampInMillis);
        out.writeVLong(this.primaryLastSuccessfulRequestTimestampInMillis);
        out.writeVLong(this.replicaLastSuccessfulRequestTimestampInMillis);
        out.writeVLong(this.currentPrimaryAndCoordinatingLimits);
        out.writeVLong(this.currentReplicaLimits);
    }

    public long getTotalCombinedCoordinatingAndPrimaryBytes() {
        return this.totalCombinedCoordinatingAndPrimaryBytes;
    }

    public long getTotalCoordinatingBytes() {
        return this.totalCoordinatingBytes;
    }

    public long getTotalPrimaryBytes() {
        return this.totalPrimaryBytes;
    }

    public long getTotalReplicaBytes() {
        return this.totalReplicaBytes;
    }

    public long getCurrentCombinedCoordinatingAndPrimaryBytes() {
        return this.currentCombinedCoordinatingAndPrimaryBytes;
    }

    public long getCurrentCoordinatingBytes() {
        return this.currentCoordinatingBytes;
    }

    public long getCurrentPrimaryBytes() {
        return this.currentPrimaryBytes;
    }

    public long getCurrentReplicaBytes() {
        return this.currentReplicaBytes;
    }

    public long getCoordinatingRejections() {
        return this.coordinatingRejections;
    }

    public long getCoordinatingNodeLimitsBreachedRejections() {
        return this.coordinatingNodeLimitsBreachedRejections;
    }

    public long getCoordinatingLastSuccessfulRequestLimitsBreachedRejections() {
        return this.coordinatingLastSuccessfulRequestLimitsBreachedRejections;
    }

    public long getCoordinatingThroughputDegradationLimitsBreachedRejections() {
        return this.coordinatingThroughputDegradationLimitsBreachedRejections;
    }

    public long getPrimaryRejections() {
        return this.primaryRejections;
    }

    public long getPrimaryNodeLimitsBreachedRejections() {
        return this.primaryNodeLimitsBreachedRejections;
    }

    public long getPrimaryLastSuccessfulRequestLimitsBreachedRejections() {
        return this.primaryLastSuccessfulRequestLimitsBreachedRejections;
    }

    public long getPrimaryThroughputDegradationLimitsBreachedRejections() {
        return this.primaryThroughputDegradationLimitsBreachedRejections;
    }

    public long getReplicaRejections() {
        return this.replicaRejections;
    }

    public long getReplicaNodeLimitsBreachedRejections() {
        return this.replicaNodeLimitsBreachedRejections;
    }

    public long getReplicaLastSuccessfulRequestLimitsBreachedRejections() {
        return this.replicaLastSuccessfulRequestLimitsBreachedRejections;
    }

    public long getReplicaThroughputDegradationLimitsBreachedRejections() {
        return this.replicaThroughputDegradationLimitsBreachedRejections;
    }

    public long getCurrentPrimaryAndCoordinatingLimits() {
        return this.currentPrimaryAndCoordinatingLimits;
    }

    public long getCurrentReplicaLimits() {
        return this.currentReplicaLimits;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.shardId);
        builder.startObject("memory");
        builder.startObject("current");
        builder.humanReadableField(COORDINATING_IN_BYTES, COORDINATING, (Object)new ByteSizeValue(this.currentCoordinatingBytes));
        builder.humanReadableField(PRIMARY_IN_BYTES, PRIMARY, (Object)new ByteSizeValue(this.currentPrimaryBytes));
        builder.humanReadableField(REPLICA_IN_BYTES, REPLICA, (Object)new ByteSizeValue(this.currentReplicaBytes));
        builder.endObject();
        builder.startObject("total");
        builder.humanReadableField(COORDINATING_IN_BYTES, COORDINATING, (Object)new ByteSizeValue(this.totalCoordinatingBytes));
        builder.humanReadableField(PRIMARY_IN_BYTES, PRIMARY, (Object)new ByteSizeValue(this.totalPrimaryBytes));
        builder.humanReadableField(REPLICA_IN_BYTES, REPLICA, (Object)new ByteSizeValue(this.totalReplicaBytes));
        builder.endObject();
        builder.endObject();
        builder.startObject("rejection");
        builder.startObject(COORDINATING);
        builder.field(COORDINATING_REJECTIONS, this.coordinatingRejections);
        if (this.shardIndexingPressureEnforced) {
            builder.startObject("breakup");
        } else {
            builder.startObject("breakup_shadow_mode");
        }
        builder.field(BREAKUP_NODE_LIMITS, this.coordinatingNodeLimitsBreachedRejections);
        builder.field(BREAKUP_NO_SUCCESSFUL_REQUEST_LIMITS, this.coordinatingLastSuccessfulRequestLimitsBreachedRejections);
        builder.field(BREAKUP_THROUGHPUT_DEGRADATION_LIMIT, this.coordinatingThroughputDegradationLimitsBreachedRejections);
        builder.endObject();
        builder.endObject();
        builder.startObject(PRIMARY);
        builder.field(PRIMARY_REJECTIONS, this.primaryRejections);
        if (this.shardIndexingPressureEnforced) {
            builder.startObject("breakup");
        } else {
            builder.startObject("breakup_shadow_mode");
        }
        builder.field(BREAKUP_NODE_LIMITS, this.primaryNodeLimitsBreachedRejections);
        builder.field(BREAKUP_NO_SUCCESSFUL_REQUEST_LIMITS, this.primaryLastSuccessfulRequestLimitsBreachedRejections);
        builder.field(BREAKUP_THROUGHPUT_DEGRADATION_LIMIT, this.primaryThroughputDegradationLimitsBreachedRejections);
        builder.endObject();
        builder.endObject();
        builder.startObject(REPLICA);
        builder.field(REPLICA_REJECTIONS, this.replicaRejections);
        if (this.shardIndexingPressureEnforced) {
            builder.startObject("breakup");
        } else {
            builder.startObject("breakup_shadow_mode");
        }
        builder.field(BREAKUP_NODE_LIMITS, this.replicaNodeLimitsBreachedRejections);
        builder.field(BREAKUP_NO_SUCCESSFUL_REQUEST_LIMITS, this.replicaLastSuccessfulRequestLimitsBreachedRejections);
        builder.field(BREAKUP_THROUGHPUT_DEGRADATION_LIMIT, this.replicaThroughputDegradationLimitsBreachedRejections);
        builder.endObject();
        builder.endObject();
        builder.endObject();
        builder.startObject("last_successful_timestamp");
        builder.field(COORDINATING_LAST_SUCCESSFUL_REQUEST_TIMESTAMP_IN_MILLIS, this.coordinatingLastSuccessfulRequestTimestampInMillis);
        builder.field(PRIMARY_LAST_SUCCESSFUL_REQUEST_TIMESTAMP_IN_MILLIS, this.primaryLastSuccessfulRequestTimestampInMillis);
        builder.field(REPLICA_LAST_SUCCESSFUL_REQUEST_TIMESTAMP_IN_MILLIS, this.replicaLastSuccessfulRequestTimestampInMillis);
        builder.endObject();
        builder.startObject("indexing");
        builder.field(COORDINATING_TIME_IN_MILLIS, this.coordinatingTimeInMillis);
        builder.field(COORDINATING_COUNT, this.totalCoordinatingCount);
        builder.field(PRIMARY_TIME_IN_MILLIS, this.primaryTimeInMillis);
        builder.field(PRIMARY_COUNT, this.totalPrimaryCount);
        builder.field(REPLICA_TIME_IN_MILLIS, this.replicaTimeInMillis);
        builder.field(REPLICA_COUNT, this.totalReplicaCount);
        builder.endObject();
        builder.startObject("memory_allocation");
        builder.startObject("current");
        builder.field(CURRENT_COORDINATING_AND_PRIMARY_IN_BYTES, this.currentCombinedCoordinatingAndPrimaryBytes);
        builder.field(CURRENT_REPLICA_IN_BYTES, this.currentReplicaBytes);
        builder.endObject();
        builder.startObject("limit");
        builder.field(CURRENT_COORDINATING_AND_PRIMARY_LIMITS_IN_BYTES, this.currentPrimaryAndCoordinatingLimits);
        builder.field(CURRENT_REPLICA_LIMITS_IN_BYTES, this.currentReplicaLimits);
        builder.endObject();
        builder.endObject();
        return builder.endObject();
    }
}

