/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.utils;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class ConcurrentInvocationLinearizer<METHOD_PARAM_TYPE, RET_TYPE> {
    private final ConcurrentMap<METHOD_PARAM_TYPE, CompletableFuture<RET_TYPE>> invokeOnceCache = new ConcurrentHashMap<METHOD_PARAM_TYPE, CompletableFuture<RET_TYPE>>();
    private final ExecutorService executorService;

    public ConcurrentInvocationLinearizer(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public CompletableFuture<RET_TYPE> linearize(METHOD_PARAM_TYPE input, Function<METHOD_PARAM_TYPE, RET_TYPE> function) {
        return this.invokeOnceCache.computeIfAbsent(input, in -> CompletableFuture.supplyAsync(() -> function.apply(in), this.executorService)).whenComplete((ret, throwable) -> this.invokeOnceCache.remove(input));
    }

    Map<METHOD_PARAM_TYPE, CompletableFuture<RET_TYPE>> getInvokeOnceCache() {
        return Collections.unmodifiableMap(this.invokeOnceCache);
    }
}

