/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.Streams;
import org.opensearch.common.io.stream.BytesStream;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;

public abstract class AbstractRestChannel
implements RestChannel {
    private static final Predicate<String> INCLUDE_FILTER = f -> f.charAt(0) != '-';
    private static final Predicate<String> EXCLUDE_FILTER = INCLUDE_FILTER.negate();
    protected final RestRequest request;
    private final boolean detailedErrorsEnabled;
    private final String format;
    private final String filterPath;
    private final boolean pretty;
    private final boolean human;
    private final String acceptHeader;
    private BytesStreamOutput bytesOut;

    protected AbstractRestChannel(RestRequest request, boolean detailedErrorsEnabled) {
        this.request = request;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
        this.format = request.param("format");
        this.acceptHeader = request.header("Accept");
        this.filterPath = request.param("filter_path", null);
        this.pretty = request.paramAsBoolean("pretty", false);
        this.human = request.paramAsBoolean("human", false);
    }

    @Override
    public XContentBuilder newBuilder() throws IOException {
        return this.newBuilder(this.request.getXContentType(), true);
    }

    @Override
    public XContentBuilder newErrorBuilder() throws IOException {
        return this.newBuilder(this.request.getXContentType(), false);
    }

    @Override
    public XContentBuilder newBuilder(@Nullable XContentType requestContentType, boolean useFiltering) throws IOException {
        return this.newBuilder(requestContentType, null, useFiltering);
    }

    @Override
    public XContentBuilder newBuilder(@Nullable XContentType requestContentType, @Nullable XContentType responseContentType, boolean useFiltering) throws IOException {
        if (responseContentType == null && (responseContentType = XContentType.fromFormat((String)this.format)) == null) {
            responseContentType = XContentType.fromMediaType((String)this.acceptHeader);
        }
        if (responseContentType == null) {
            responseContentType = requestContentType != null ? requestContentType : XContentType.JSON;
        }
        Set includes = Collections.emptySet();
        Set excludes = Collections.emptySet();
        if (useFiltering) {
            Set<String> filters = Strings.tokenizeByCommaToSet(this.filterPath);
            includes = filters.stream().filter(INCLUDE_FILTER).collect(Collectors.toSet());
            excludes = filters.stream().filter(EXCLUDE_FILTER).map(f -> f.substring(1)).collect(Collectors.toSet());
        }
        BytesStream unclosableOutputStream = Streams.flushOnCloseStream(this.bytesOutput());
        XContentBuilder builder = new XContentBuilder(XContentFactory.xContent((XContentType)responseContentType), (OutputStream)unclosableOutputStream, includes, excludes);
        if (this.pretty) {
            builder.prettyPrint().lfAtEnd();
        }
        builder.humanReadable(this.human);
        return builder;
    }

    @Override
    public final BytesStreamOutput bytesOutput() {
        if (this.bytesOut == null) {
            this.bytesOut = this.newBytesOutput();
        } else {
            this.bytesOut.reset();
        }
        return this.bytesOut;
    }

    protected final BytesStreamOutput bytesOutputOrNull() {
        return this.bytesOut;
    }

    protected BytesStreamOutput newBytesOutput() {
        return new BytesStreamOutput();
    }

    @Override
    public RestRequest request() {
        return this.request;
    }

    @Override
    public boolean detailedErrorsEnabled() {
        return this.detailedErrorsEnabled;
    }
}

