/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.support.ContextPreservingActionListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ClusterConnectionManager;
import org.opensearch.transport.ConnectionManager;
import org.opensearch.transport.ConnectionProfile;
import org.opensearch.transport.RemoteClusterService;
import org.opensearch.transport.RemoteConnectionInfo;
import org.opensearch.transport.RemoteConnectionManager;
import org.opensearch.transport.RemoteConnectionStrategy;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

final class RemoteClusterConnection
implements Closeable {
    private final TransportService transportService;
    private final RemoteConnectionManager remoteConnectionManager;
    private final RemoteConnectionStrategy connectionStrategy;
    private final String clusterAlias;
    private final ThreadPool threadPool;
    private volatile boolean skipUnavailable;
    private final TimeValue initialConnectionTimeout;

    RemoteClusterConnection(Settings settings, String clusterAlias, TransportService transportService) {
        this.transportService = transportService;
        this.clusterAlias = clusterAlias;
        ConnectionProfile profile = RemoteConnectionStrategy.buildConnectionProfile(clusterAlias, settings);
        this.remoteConnectionManager = new RemoteConnectionManager(clusterAlias, RemoteClusterConnection.createConnectionManager(profile, transportService));
        this.connectionStrategy = RemoteConnectionStrategy.buildStrategy(clusterAlias, transportService, this.remoteConnectionManager, settings);
        this.remoteConnectionManager.addListener(transportService);
        this.skipUnavailable = RemoteClusterService.REMOTE_CLUSTER_SKIP_UNAVAILABLE.getConcreteSettingForNamespace(clusterAlias).get(settings);
        this.threadPool = transportService.threadPool;
        this.initialConnectionTimeout = RemoteClusterService.REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING.get(settings);
    }

    void updateSkipUnavailable(boolean skipUnavailable) {
        this.skipUnavailable = skipUnavailable;
    }

    boolean isSkipUnavailable() {
        return this.skipUnavailable;
    }

    void ensureConnected(ActionListener<Void> listener) {
        if (this.remoteConnectionManager.size() == 0) {
            this.connectionStrategy.connect(listener);
        } else {
            listener.onResponse(null);
        }
    }

    void collectNodes(ActionListener<Function<String, DiscoveryNode>> listener) {
        Runnable runnable = () -> {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            final ContextPreservingActionListener contextPreservingActionListener = new ContextPreservingActionListener(threadContext.newRestorableContext(false), listener);
            try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                threadContext.markAsSystemContext();
                ClusterStateRequest request = new ClusterStateRequest();
                request.clear();
                request.nodes(true);
                request.local(true);
                Transport.Connection connection = this.remoteConnectionManager.getAnyRemoteConnection();
                this.transportService.sendRequest(connection, "cluster:monitor/state", (TransportRequest)request, TransportRequestOptions.EMPTY, new TransportResponseHandler<ClusterStateResponse>(){

                    @Override
                    public ClusterStateResponse read(StreamInput in) throws IOException {
                        return new ClusterStateResponse(in);
                    }

                    @Override
                    public void handleResponse(ClusterStateResponse response) {
                        DiscoveryNodes nodes = response.getState().nodes();
                        contextPreservingActionListener.onResponse(nodes::get);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        contextPreservingActionListener.onFailure(exp);
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }
                });
            }
        };
        try {
            this.ensureConnected(ActionListener.wrap(x -> runnable.run(), listener::onFailure));
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    Transport.Connection getConnection(DiscoveryNode remoteClusterNode) {
        return this.remoteConnectionManager.getConnection(remoteClusterNode);
    }

    Transport.Connection getConnection() {
        return this.remoteConnectionManager.getAnyRemoteConnection();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.connectionStrategy, this.remoteConnectionManager});
    }

    public boolean isClosed() {
        return this.connectionStrategy.isClosed();
    }

    boolean assertNoRunningConnections() {
        return this.connectionStrategy.assertNoRunningConnections();
    }

    boolean isNodeConnected(DiscoveryNode node) {
        return this.remoteConnectionManager.nodeConnected(node);
    }

    public RemoteConnectionInfo getConnectionInfo() {
        return new RemoteConnectionInfo(this.clusterAlias, this.connectionStrategy.getModeInfo(), this.initialConnectionTimeout, this.skipUnavailable);
    }

    int getNumNodesConnected() {
        return this.remoteConnectionManager.size();
    }

    private static ConnectionManager createConnectionManager(ConnectionProfile connectionProfile, TransportService transportService) {
        return new ClusterConnectionManager(connectionProfile, transportService.transport);
    }

    ConnectionManager getConnectionManager() {
        return this.remoteConnectionManager;
    }

    boolean shouldRebuildConnection(Settings newSettings) {
        return this.connectionStrategy.shouldRebuildConnection(newSettings);
    }
}

