/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.module.AbstractModuleInstance;
import de.virtimo.bpc.module.monitor.MonitorModule;
import de.virtimo.bpc.module.monitor.OpenSearch;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.cluster.metadata.MappingMetadata;

public class MonitorModuleInstance
extends AbstractModuleInstance {
    private static final Logger LOG = Logger.getLogger(MonitorModuleInstance.class.getName());
    public static final String SETTING_COLUMN_CONFIG = "column_config";
    public static final String SETTING_DATA_INDEX = "data_index";
    public static final String SETTING_DATA_EXCLUDED_FIELDS = "data_excludedFields";
    public static final String SETTING_DATA_HISTORY_INDEX = "data_historyIndex";
    public static final String SETTING_DATA_FILTER = "data_filter";
    public static final String SETTING_DATA_REFRESH_BUFFER = "data_refreshBuffer";
    public static final String SETTING_MAX_RESULT_WINDOW = "instance_data_view_limit";
    public static final String SETTING_MAX_DATA_COUNT = "instance_data_count_limit";
    public static final String SETTING_ID_COLUMN = "column_id";
    public static final String SETTING_HISTORY_ID = "column_historyId";
    public static final String SETTING_HISTORY_SUB_ID = "column_historySubId";
    public static final String SETTING_COLUMN_LIST = "column_list";
    public static final String SETTING_COLUMN_TIMESERIES = "column_timeseries";
    public static final String SETTING_COLUMN_FILE = "column_file";
    public static final String SETTING_COLUMN_MIMETYPE = "column_mimetype";
    public static final String SETTING_HISTORY_COLUMN_LIST = "column_historyList";
    public static final String SETTING_HISTORY_COLUMN_CONFIG = "column_historyConfig";
    public static final String SETTING_DATAEXPORT_ENABLE = "function_exportEnable";
    public static final String SETTING_DATAEXPORT_FORMAT_JSON = "function_exportConfigJson";
    public static final String SETTING_DATAEXPORT_FORMAT_JSON_INCL_HIDDEN = "function_exportConfigJsonInclHidden";
    public static final String SETTING_DATAEXPORT_FORMAT_JSON_USE_CUSTOM_COLUMN_HEADERS = "function_exportConfigJsonUseCustomColumnHeaders";
    public static final String SETTING_DATAEXPORT_FORMAT_JSON_USE_UTC_DATE_FORMAT = "function_exportConfigJsonUseUTCDateFormat";
    public static final String SETTING_DATAEXPORT_FORMAT_XLSX = "function_exportConfigXlsx";
    public static final String SETTING_DATAEXPORT_FORMAT_XLSX_INCL_HIDDEN = "function_exportConfigXlsxInclHidden";
    public static final String SETTING_DATAEXPORT_FORMAT_XLSX_AUTO_RESIZE_COLUMNS = "function_exportConfigXlsxAutoResizeColumns";
    public static final String SETTING_DATAEXPORT_FORMAT_XLSX_USE_CUSTOM_COLUMN_HEADERS = "function_exportConfigXlsxUseCustomColumnHeaders";
    public static final String SETTING_DATAEXPORT_FORMAT_CSV = "function_exportConfigCsv";
    public static final String SETTING_DATAEXPORT_FORMAT_CSV_SEPARATOR = "function_exportConfigCsvSeparator";
    public static final String SETTING_DATAEXPORT_FORMAT_CSV_INCL_HIDDEN = "function_exportConfigCsvInclHidden";
    public static final String SETTING_DATAEXPORT_FORMAT_CSV_USE_CUSTOM_COLUMN_HEADERS = "function_exportConfigCsvUseCustomColumnHeaders";
    public static final String SETTING_RESOURCE_SAVING_MODE = "resource_saving_mode";
    public static final String SETTING_FUNCTION_GRID_MULTIVIEWS_ENABLE = "function_gridMultipleViews";
    public static final String SETTING_FUNCTION_GRID_MULTIVIEWS_CONFIG = "function_gridMultipleViewsConfig";
    public static final String SETTING_INUBIT_PROXY = "inubit_proxyId";
    public static final String SETTING_INUBIT_BASE_URL = "inubit_baseUrl";
    public static final String SETTING_INUBIT_TABLE_PREFIX = "inubit_dbTablePrefix";
    public static final String SETTING_INUBIT_REFERENCE_ENDPOINT = "inubit_referenceEndpoint";
    private static final Object COLUMN_SETTINGS_LOCK = new Object();
    private boolean initialParentIndexMappingProcessed = false;
    private boolean initialChildIndexMappingProcessed = false;

    public MonitorModuleInstance(InstantiableModule pm, ModuleConfiguration mc, String instanceId) {
        super(pm, mc, instanceId);
    }

    public void destroy() {
        LOG.info("destroy");
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleConfiguration getConfiguration() {
        LOG.info(this.getModuleId() + ": getConfiguration");
        ModuleConfiguration m = super.getConfiguration();
        Object object = COLUMN_SETTINGS_LOCK;
        synchronized (object) {
            try {
                String childIndex;
                String index = m.getSettingValue(SETTING_DATA_INDEX).asString("").toLowerCase();
                if (!StringUtil.isNullOrEmpty((String)index)) {
                    Setting currentColumnListSetting = m.getSetting(SETTING_COLUMN_LIST);
                    Object currentColumnListValue = currentColumnListSetting.getValue();
                    if (!this.initialParentIndexMappingProcessed && currentColumnListValue == null || currentColumnListValue instanceof Map && ((Map)currentColumnListValue).isEmpty()) {
                        this.initialParentIndexMappingProcessed = true;
                        LOG.info(this.getModuleId() + ": add setting: column_list");
                        OpenSearch openSearch = ((MonitorModule)this.getParentModule()).getOpenSearch();
                        Map parentIndexMapping = openSearch.getIndexMapping(index);
                        if (parentIndexMapping != null) {
                            ((SimpleSettingImpl)currentColumnListSetting).setValue((Object)parentIndexMapping);
                            m.addSetting(currentColumnListSetting, true);
                        }
                    }
                }
                if (!StringUtil.isNullOrEmpty((String)(childIndex = m.getSettingValue(SETTING_DATA_HISTORY_INDEX).asString("").toLowerCase()))) {
                    Setting currentHistoryColumnListSetting = m.getSetting(SETTING_HISTORY_COLUMN_LIST);
                    Object currentHistoryColumnListValue = currentHistoryColumnListSetting.getValue();
                    if (!this.initialChildIndexMappingProcessed && currentHistoryColumnListValue == null || currentHistoryColumnListValue instanceof Map && ((Map)currentHistoryColumnListValue).isEmpty()) {
                        this.initialChildIndexMappingProcessed = true;
                        LOG.info(this.getModuleId() + ": add setting: column_historyList");
                        OpenSearch openSearch = ((MonitorModule)this.getParentModule()).getOpenSearch();
                        Map childIndexMapping = openSearch.getIndexMapping(childIndex);
                        if (childIndexMapping != null) {
                            ((SimpleSettingImpl)currentHistoryColumnListSetting).setValue((Object)childIndexMapping);
                            m.addSetting(currentHistoryColumnListSetting, true);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, this.getModuleId() + ": Error getting OpenSearch mapping.", e);
            }
        }
        return m;
    }

    protected void applyUpdatedConfiguration() {
        LOG.info(this.getModuleId() + ": applyUpdatedConfiguration");
        this.indexToDefaultColumnConfiguration(SETTING_DATA_INDEX, SETTING_COLUMN_CONFIG);
        this.indexToDefaultColumnConfiguration(SETTING_DATA_HISTORY_INDEX, SETTING_HISTORY_COLUMN_CONFIG);
    }

    private void indexToDefaultColumnConfiguration(String dataIndexSettingName, String columnConfigSettingName) {
        ModuleConfiguration m = this.getConfiguration();
        try {
            Object monitorColumnConfigs;
            boolean configureColumnConfig = true;
            Setting existingColumnConfigSetting = m.getSetting(columnConfigSettingName);
            if (existingColumnConfigSetting != null && (monitorColumnConfigs = existingColumnConfigSetting.getValue()) instanceof ArrayList && ((ArrayList)monitorColumnConfigs).size() > 0) {
                configureColumnConfig = false;
            }
            if (configureColumnConfig) {
                LOG.info(this.getModuleId() + ": generate setting column_config");
                String index = m.getSettingValue(dataIndexSettingName).asString("").toLowerCase();
                MappingMetadata mmd = null;
                if (!StringUtil.isNullOrEmpty((String)index)) {
                    mmd = ((MonitorModule)this.getParentModule()).getOpenSearch().getOpenSearchService().getMappingMetaData(index);
                }
                if (mmd != null) {
                    Map fieldMap = (Map)mmd.getSourceAsMap().get("properties");
                    ArrayList columnConfig = new ArrayList();
                    for (String fieldName : fieldMap.keySet()) {
                        Map fieldConfig;
                        if (fieldName.equals("_percolator_query") || !((fieldConfig = (Map)fieldMap.get(fieldName)).get("type") instanceof String)) continue;
                        HashMap<String, Object> column = new HashMap<String, Object>();
                        column.put("dataIndex", fieldName);
                        column.put("text", fieldName);
                        column.put("hidden", false);
                        column.put("hideable", true);
                        column.put("width", 200);
                        column.put("minWidth", 64);
                        column.put("customRenderer", false);
                        String filterType = "text";
                        String fieldType = fieldConfig.get("type").toString();
                        if (fieldType.equals("date")) {
                            column.put("xtype", "datecolumn");
                            filterType = "daterange";
                        } else if (fieldType.equals("long") || fieldType.equals("double")) {
                            filterType = "number";
                        } else if (fieldType.equals("boolean")) {
                            filterType = "check";
                        } else if (fieldType.equals("attachment")) {
                            column.put("xtype", "attachmentcolumn");
                        }
                        HashMap<String, String> filterDefaultMap = new HashMap<String, String>();
                        filterDefaultMap.put("type", filterType);
                        if (fieldName.equalsIgnoreCase("status")) {
                            filterDefaultMap.put("source", "lowercase");
                        } else {
                            filterDefaultMap.put("source", "raw");
                        }
                        column.put("filter", filterDefaultMap);
                        columnConfig.add(column);
                    }
                    Setting columnConfigSetting = m.getSetting(columnConfigSettingName);
                    SimpleSettingImpl newColumnConfigSetting = new SimpleSettingImpl(columnConfigSetting);
                    newColumnConfigSetting.setValue(columnConfig);
                    m.updateSetting((Setting)newColumnConfigSetting, true);
                } else {
                    LOG.warning(this.getModuleId() + ": Can't read metadata from data source. Check setting 'data_index'.");
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, this.getModuleId() + ": Error: " + e.getMessage(), e);
        }
    }
}

