/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.query;

import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcQueryBuilder;
import de.virtimo.bpc.module.monitor.query.SessionBasedQuery;
import de.virtimo.bpc.module.monitor.query.ViewQuery;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public class DateRangeQuery {
    private static final Logger LOG = Logger.getLogger(DateRangeQuery.class.getName());

    public static QueryBuilder getQueryBuilder(String view, String startDate, String endDate, String timeseriesColumn, UserSession userSession, String timeZoneId, ModuleInstance mi, String index, Map<String, Object> dataFilterSetting) throws IOException {
        LOG.info("getQueryBuilder view=" + view + ", startDate=" + startDate + ", endDate=" + endDate + ", timeseriesColumn=" + timeseriesColumn + ", userSession=..., timeZoneId=" + timeZoneId + ", mi=..., index=" + index + ", dataFilterSetting=...");
        QueryBuilder query = new BpcQueryBuilder(index).addQueryBuilder(SessionBasedQuery.getQueryBuilder(userSession, dataFilterSetting)).addDateRangeQuery(timeseriesColumn, startDate, endDate, timeZoneId).addSkipPercolatorDocumentsQuery().buildAsBoolFilterQuery();
        QueryBuilder viewQuery = ViewQuery.getQueryBuilder(mi, view, userSession);
        if (viewQuery != null) {
            return QueryBuilders.boolQuery().must(query).must(viewQuery);
        }
        return query;
    }
}

