/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public class SessionBasedQuery {
    private static final Logger LOG = Logger.getLogger(SessionBasedQuery.class.getName());
    public static final String DATA_FILTER_BASEFILTER_KEY = "baseFilter";
    public static final String DATA_FILTER_ORGANISATIONS_KEY = "organisations";
    public static final String DATA_FILTER_ROLES_KEY = "roles";
    public static final String DATA_FILTER_RIGHTS_KEY = "rights";
    public static final String DATA_FILTER_USERS_KEY = "users";

    public static QueryBuilder getQueryBuilder(UserSession session, Map<String, Object> dataFilterConfig) throws IOException {
        BoolQueryBuilder organisationQuery;
        LOG.info("getQueryBuilder session=..., dataFilterConfig=...");
        BoolQueryBuilder sessionQuery = null;
        if (dataFilterConfig == null) {
            LOG.warning("No filter config found");
            return QueryBuilders.matchAllQuery();
        }
        BoolQueryBuilder baseQuery = QueryBuilders.boolQuery();
        if (dataFilterConfig.containsKey(DATA_FILTER_BASEFILTER_KEY)) {
            baseQuery = SessionBasedQuery.getQueryForList((List)dataFilterConfig.get(DATA_FILTER_BASEFILTER_KEY), session);
        }
        if (baseQuery.hasClauses()) {
            LOG.info("add baseQuery");
            sessionQuery = QueryBuilders.boolQuery().should((QueryBuilder)baseQuery);
        } else {
            sessionQuery = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (dataFilterConfig.containsKey(DATA_FILTER_ROLES_KEY)) {
            BoolQueryBuilder roleQuery = QueryBuilders.boolQuery();
            Map roles = (Map)dataFilterConfig.get(DATA_FILTER_ROLES_KEY);
            List sessionRoles = session.getRoles();
            for (Role role : sessionRoles) {
                if (!roles.containsKey(role.getName())) continue;
                roleQuery.should((QueryBuilder)SessionBasedQuery.getQueryForList((List)roles.get(role.getName()), session));
            }
            if (roles.containsKey("#")) {
                for (Role role : sessionRoles) {
                    roleQuery.should((QueryBuilder)SessionBasedQuery.getReplacedQueryForList((List)roles.get("#"), "#this.name#", role.getName()));
                }
            }
            if (roleQuery.hasClauses()) {
                LOG.info("add roleQuery");
                sessionQuery.should((QueryBuilder)roleQuery);
            }
        }
        if (dataFilterConfig.containsKey(DATA_FILTER_RIGHTS_KEY)) {
            BoolQueryBuilder rightQuery = QueryBuilders.boolQuery();
            Map rights = (Map)dataFilterConfig.get(DATA_FILTER_RIGHTS_KEY);
            List sessionRights = session.getRights();
            for (Right right : sessionRights) {
                if (!rights.containsKey(right.getName())) continue;
                rightQuery.should((QueryBuilder)SessionBasedQuery.getQueryForList((List)rights.get(right.getName()), session));
            }
            if (rights.containsKey("#")) {
                for (Right right : sessionRights) {
                    rightQuery.should((QueryBuilder)SessionBasedQuery.getReplacedQueryForList((List)rights.get("#"), "#this.name#", right.getName()));
                }
            }
            if (rightQuery.hasClauses()) {
                LOG.info("add rightQuery");
                sessionQuery.should((QueryBuilder)rightQuery);
            }
        }
        if (dataFilterConfig.containsKey(DATA_FILTER_ORGANISATIONS_KEY)) {
            organisationQuery = QueryBuilders.boolQuery();
            Map organisations = (Map)dataFilterConfig.get(DATA_FILTER_ORGANISATIONS_KEY);
            List sessionOrganisations = session.getOrganisations();
            for (Organisation org : sessionOrganisations) {
                if (!organisations.containsKey(org.getName())) continue;
                organisationQuery.should((QueryBuilder)SessionBasedQuery.getQueryForList((List)organisations.get(org.getName()), session));
            }
            if (organisations.containsKey("#")) {
                for (Organisation org : sessionOrganisations) {
                    organisationQuery.should((QueryBuilder)SessionBasedQuery.getReplacedQueryForList((List)organisations.get("#"), "#this.name#", org.getName()));
                }
            }
            if (organisationQuery.hasClauses()) {
                LOG.info("add organisationQuery");
                sessionQuery.should((QueryBuilder)organisationQuery);
            }
        }
        if (dataFilterConfig.containsKey(DATA_FILTER_USERS_KEY)) {
            String userName;
            organisationQuery = QueryBuilders.boolQuery();
            Map users = (Map)dataFilterConfig.get(DATA_FILTER_USERS_KEY);
            if (users.containsKey(userName = session.getLoginName())) {
                organisationQuery.should((QueryBuilder)SessionBasedQuery.getQueryForList((List)users.get(userName), session));
            }
            if (users.containsKey("#")) {
                organisationQuery.should((QueryBuilder)SessionBasedQuery.getReplacedQueryForList((List)users.get("#"), "#this.name#", userName));
            }
            if (organisationQuery.hasClauses()) {
                LOG.info("add organisationQuery");
                sessionQuery.should((QueryBuilder)organisationQuery);
            }
        }
        return sessionQuery;
    }

    public static QueryBuilder getQueryForMap(Map<String, Object> filterMap, UserSession session) throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        return QueryBuilders.wrapperQuery((String)SessionBasedQuery.prepareFilterString(session, om.writeValueAsString(filterMap)));
    }

    private static BoolQueryBuilder getQueryForList(List<Map<String, Object>> filterList, UserSession session) throws IOException {
        LOG.info("getQueryForList");
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        for (Map<String, Object> filterMap : filterList) {
            LOG.info("add wrapperQuery");
            query.must(SessionBasedQuery.getQueryForMap(filterMap, session));
        }
        return query;
    }

    private static BoolQueryBuilder getReplacedQueryForList(List<Map<String, Object>> filterList, String pattern, String replaceString) throws IOException {
        LOG.fine("getReplacedQueryForList filterList=" + filterList + ", pattern=" + pattern + ", replaceString=" + replaceString);
        if (!StringUtil.isNullOrEmpty((String)replaceString)) {
            replaceString = JsonUtil.crunchifyJSONEscapeUtil((String)replaceString);
        }
        ObjectMapper om = new ObjectMapper();
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        for (Map<String, Object> filterMap : filterList) {
            LOG.info("add wrapperQuery");
            String filterAsString = om.writeValueAsString(filterMap);
            String filterAsStringWithPatternReplaced = filterAsString.replaceAll(pattern, Matcher.quoteReplacement(replaceString));
            query.must((QueryBuilder)QueryBuilders.wrapperQuery((String)filterAsStringWithPatternReplaced));
        }
        return query;
    }

    public static String prepareFilterString(UserSession userSession, String filterString) {
        LOG.finest("prepareFilterString userSession=" + userSession + ", filterString=" + filterString);
        if (userSession == null || filterString == null) {
            return filterString;
        }
        return filterString.replaceAll("#user.loginName#", userSession.getLoginName());
    }
}

