/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.query;

import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.module.monitor.query.SessionBasedQuery;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.index.query.QueryBuilder;

public class ViewQuery {
    private static final Logger LOG = Logger.getLogger(ViewQuery.class.getName());

    public static QueryBuilder getQueryBuilder(ModuleInstance mi, String view, UserSession userSession) {
        LOG.info("getQueryBuilder mi=..., view=..., userSession=...");
        if (view != null && view.length() > 0) {
            LOG.info("Check viewConfig for view " + view);
            try {
                Map multiViewConfig = (Map)mi.getConfiguration().getSetting("function_gridMultipleViewsConfig").getValue();
                if (multiViewConfig.containsKey("views")) {
                    LOG.info("Config found");
                    List viewList = (List)multiViewConfig.get("views");
                    if (viewList != null) {
                        for (Map viewConfig : viewList) {
                            if (!viewConfig.containsKey("id") || !((String)viewConfig.get("id")).equalsIgnoreCase(view)) continue;
                            if (!viewConfig.containsKey("filter")) break;
                            LOG.info("Add view filter");
                            Map filterMap = (Map)viewConfig.get("filter");
                            return SessionBasedQuery.getQueryForMap(filterMap, userSession);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }
}

