/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.resource;

import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.module.monitor.resource.MonitorDataExporter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.search.SearchHit;

public class MonitorDataCsvExporter
extends MonitorDataExporter {
    private static final Logger LOG = Logger.getLogger(MonitorDataCsvExporter.class.getName());
    public static final int EXCEL_STYLE_ESCAPING = 0;
    public static final int UNIX_STYLE_ESCAPING = 1;
    public static final String MONITOR_COLUMN_CONFIG_IDENTIFIER_CSV_EXPORT_FORMAT = "formatCsvExport";
    public static final String MONITOR_COLUMN_CONFIG_IDENTIFIER_CSV_EXPORT_LANGUAGE_TAG = "languageTagCsvExport";
    private boolean useCustomColumnHeaders = true;
    private int formattingConvention = 0;
    private String columnSeparator = ";";
    private TimeZone timeZone;
    private SimpleDateFormat defaultDateFormat;
    private HashMap<String, SimpleDateFormat> dateFormatsCache;
    private HashMap<String, NumberFormat> numberFormatsCache;

    public MonitorDataCsvExporter(ModuleInstance mi, MappingMetadata mappingMetaData, List<String> inclOnlyThisColumns, boolean inclHidden, String timeZoneId, Map<String, Object> translationsForBpcLanguage) throws IOException {
        super(mi, mappingMetaData, inclOnlyThisColumns, inclHidden, translationsForBpcLanguage);
        this.timeZone = timeZoneId != null ? TimeZone.getTimeZone(timeZoneId) : null;
        LOG.info("Using the time zone: " + this.timeZone + " (null = using the server time zone). Given timeZoneId: " + timeZoneId);
        this.defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.timeZone != null) {
            this.defaultDateFormat.setTimeZone(this.timeZone);
        }
        this.dateFormatsCache = new HashMap();
        this.numberFormatsCache = new HashMap();
    }

    public boolean isUseCustomColumnHeaders() {
        return this.useCustomColumnHeaders;
    }

    public void setUseCustomColumnHeaders(boolean useCustomColumnHeaders) {
        this.useCustomColumnHeaders = useCustomColumnHeaders;
    }

    public int getFormattingConvention() {
        return this.formattingConvention;
    }

    public void setFormattingConvention(int formattingConvention) {
        this.formattingConvention = formattingConvention;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    private SimpleDateFormat getDateFormat(String columnName) {
        String customDateFormat = this.getMonitorColumnConfigStringSetting(columnName, MONITOR_COLUMN_CONFIG_IDENTIFIER_CSV_EXPORT_FORMAT);
        if (customDateFormat != null) {
            try {
                SimpleDateFormat dateFormat = this.dateFormatsCache.get(customDateFormat);
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat(customDateFormat);
                    if (this.timeZone != null) {
                        dateFormat.setTimeZone(this.timeZone);
                    }
                    this.dateFormatsCache.put(customDateFormat, dateFormat);
                }
                return dateFormat;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "The CSV export date pattern '" + customDateFormat + "' for the the column '" + columnName + "' is invalid (must be a Java SimpleDateFormat pattern).", ex);
            }
        }
        return null;
    }

    private NumberFormat getNumberFormat(String columnName) {
        String customNumberFormat = this.getMonitorColumnConfigStringSetting(columnName, MONITOR_COLUMN_CONFIG_IDENTIFIER_CSV_EXPORT_FORMAT);
        if (customNumberFormat != null) {
            try {
                NumberFormat numberFormat = this.numberFormatsCache.get(customNumberFormat);
                if (numberFormat == null) {
                    String languageTag = this.getMonitorColumnConfigStringSetting(columnName, MONITOR_COLUMN_CONFIG_IDENTIFIER_CSV_EXPORT_LANGUAGE_TAG);
                    numberFormat = languageTag != null ? NumberFormat.getNumberInstance(Locale.forLanguageTag(languageTag)) : NumberFormat.getNumberInstance();
                    ((DecimalFormat)numberFormat).applyPattern(customNumberFormat);
                    this.numberFormatsCache.put(customNumberFormat, numberFormat);
                }
                return numberFormat;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "The CSV export number pattern '" + customNumberFormat + "' for the the column '" + columnName + "' is invalid (must be a Java NumberFormat pattern).", ex);
            }
        }
        return null;
    }

    public void writeSearchResponseToOutputStream(RestHighLevelClient osClient, SearchResponse scrollResp, Integer limit, OutputStream outputStream) throws IOException {
        LOG.info("writeSearchResponseToOutputStream");
        ArrayList<MonitorDataExporter.MonitorDataExportColumn> monitorDataExportColumns = this.getMonitorDataExportColumns(this.useCustomColumnHeaders);
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream));){
            int maxColumns = monitorDataExportColumns.size();
            int colIdx = 0;
            for (MonitorDataExporter.MonitorDataExportColumn monitorDataExportColumn : monitorDataExportColumns) {
                String outValue = monitorDataExportColumn.getColumnNameForExport();
                if (outValue != null) {
                    bw.write(this.escapeEmbeddedCharacters(outValue));
                }
                if (colIdx < maxColumns - 1) {
                    bw.write(this.columnSeparator);
                }
                ++colIdx;
            }
            bw.newLine();
            int rowIdx = 0;
            boolean done = false;
            while (!done) {
                for (SearchHit hit : scrollResp.getHits().getHits()) {
                    Map sourceValues = hit.getSourceAsMap();
                    colIdx = 0;
                    for (MonitorDataExporter.MonitorDataExportColumn monitorDataExportColumn : monitorDataExportColumns) {
                        String columnName = monitorDataExportColumn.getColumnName();
                        Object columnValue = sourceValues.get(columnName);
                        String outValue = null;
                        if (columnValue != null) {
                            String columnType = this.getOpenSearchColumnType(columnName);
                            if ("date".equalsIgnoreCase(columnType)) {
                                SimpleDateFormat dateFormat;
                                Date date = this.getDateFromValue(columnValue);
                                outValue = date != null ? ((dateFormat = this.getDateFormat(columnName)) != null ? dateFormat.format(date) : this.defaultDateFormat.format(date)) : columnValue.toString();
                            } else if (Arrays.asList("long", "integer", "short", "byte", "double", "float", "half_float").contains(columnType)) {
                                NumberFormat numberFormat = this.getNumberFormat(columnName);
                                if (numberFormat != null) {
                                    try {
                                        outValue = numberFormat.format(columnValue);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        LOG.log(Level.SEVERE, "Could not format the value '" + columnValue + "' with the number pattern '" + numberFormat + "'.", ex);
                                        outValue = columnValue.toString();
                                    }
                                } else {
                                    outValue = columnValue.toString();
                                }
                            } else if ("scaled_float".equalsIgnoreCase(columnType)) {
                                String scalingFactor = this.getOpenSearchMappingFieldConfig(columnName).get("scaling_factor").toString();
                                LOG.warning("Formatting column '" + columnName + "' of type '" + columnType + "' and value class '" + columnValue.getClass().getName() + "' is not yet implemented.");
                                outValue = columnValue.toString();
                            } else {
                                outValue = columnValue.toString();
                            }
                        }
                        if (outValue != null) {
                            bw.write(this.escapeEmbeddedCharacters(outValue));
                        }
                        if (colIdx < maxColumns - 1) {
                            bw.write(this.columnSeparator);
                        }
                        ++colIdx;
                    }
                    bw.newLine();
                    if (limit != null && ++rowIdx >= limit) {
                        LOG.info("Stop .... export limit of " + limit + " rows reached (" + rowIdx + ")");
                        done = true;
                        break;
                    }
                    if (rowIdx % 5000 != 0) continue;
                    bw.flush();
                }
                if (done || (scrollResp = osClient.scroll(new SearchScrollRequest(scrollResp.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0) continue;
                LOG.info("Stop ... no more hits");
                done = true;
                break;
            }
        }
    }

    private String escapeEmbeddedCharacters(String field) {
        if (this.formattingConvention == 0) {
            StringBuffer buffer;
            if (field.contains("\"")) {
                buffer = new StringBuffer(field.replaceAll("\"", "\\\"\\\""));
                buffer.insert(0, "\"");
                buffer.append("\"");
            } else {
                buffer = new StringBuffer(field);
                if (buffer.indexOf(this.columnSeparator) > -1 || buffer.indexOf("\n") > -1) {
                    buffer.insert(0, "\"");
                    buffer.append("\"");
                }
            }
            return buffer.toString().trim();
        }
        if (field.contains(this.columnSeparator)) {
            field = field.replaceAll(this.columnSeparator, "\\\\" + this.columnSeparator);
        }
        if (field.contains("\n")) {
            field = field.replaceAll("\n", "\\\\\n");
        }
        return field;
    }
}

