/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.resource;

import de.virtimo.bpc.api.ModuleInstance;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.cluster.metadata.MappingMetadata;

public abstract class MonitorDataExporter {
    private static final Logger LOG = Logger.getLogger(MonitorDataExporter.class.getName());
    private ArrayList<String> columnNames;
    private HashMap<String, String> columnTypes;
    private HashMap<String, HashMap> monitorColumnsConfig;
    private HashMap<String, Map<String, Object>> openSearchColumnsMapping;
    private Map<String, Object> translationsForBpcLanguage;

    protected MonitorDataExporter(ModuleInstance moduleInstance, MappingMetadata openSearchMappingMetaData, List<String> inclOnlyThisColumns, boolean inclHidden, Map<String, Object> translationsForBpcLanguage) throws IOException {
        this.translationsForBpcLanguage = translationsForBpcLanguage;
        this.columnNames = new ArrayList();
        this.columnTypes = new HashMap();
        this.monitorColumnsConfig = new HashMap();
        this.openSearchColumnsMapping = new HashMap();
        Map openSearchMappings = (Map)openSearchMappingMetaData.getSourceAsMap().get("properties");
        ArrayList monitorColumnConfigs = (ArrayList)moduleInstance.getConfiguration().getSetting("column_config").getValue();
        if (inclOnlyThisColumns == null || inclOnlyThisColumns.isEmpty()) {
            for (Object columnConfigObject : monitorColumnConfigs) {
                HashMap columnConfigMap = (HashMap)columnConfigObject;
                String columnName = columnConfigMap.getOrDefault("dataIndex", null);
                boolean hidden = columnConfigMap.getOrDefault("hidden", Boolean.FALSE);
                if (columnName == null || hidden && !inclHidden) continue;
                this.initColumn(columnName, columnConfigMap, openSearchMappings);
            }
        } else {
            for (String columnName : inclOnlyThisColumns) {
                HashMap columnConfigMap = this.getColumnConfigMap(monitorColumnConfigs, columnName);
                if (columnConfigMap == null) continue;
                this.initColumn(columnName, columnConfigMap, openSearchMappings);
            }
        }
    }

    private void initColumn(String columnName, HashMap columnConfigMap, Map<String, Object> openSearchMappings) {
        Map openSearchColumnMapping = (Map)openSearchMappings.get(columnName);
        if (openSearchColumnMapping != null) {
            this.columnNames.add(columnName);
            Object mappingTypeObject = openSearchColumnMapping.get("type");
            if (mappingTypeObject == null) {
                LOG.warning("There is no type set for column '" + columnName + "'");
            } else {
                this.columnTypes.put(columnName, mappingTypeObject.toString());
            }
            this.monitorColumnsConfig.put(columnName, columnConfigMap);
            this.openSearchColumnsMapping.put(columnName, openSearchColumnMapping);
        }
    }

    private HashMap getColumnConfigMap(ArrayList monitorColumnConfigs, String columnName) {
        for (Object columnConfigObject : monitorColumnConfigs) {
            HashMap columnConfigMap = (HashMap)columnConfigObject;
            String configColumnName = columnConfigMap.getOrDefault("dataIndex", null);
            if (configColumnName == null || !configColumnName.equalsIgnoreCase(columnName)) continue;
            return columnConfigMap;
        }
        return null;
    }

    protected Object getMonitorColumnConfigSetting(String columnName, String settingName) {
        HashMap monitorColumnConfig;
        if (this.monitorColumnsConfig != null && columnName != null && (monitorColumnConfig = this.monitorColumnsConfig.get(columnName)) != null) {
            return monitorColumnConfig.get(settingName);
        }
        return null;
    }

    protected String getMonitorColumnConfigStringSetting(String columnName, String settingName) {
        Object value = this.getMonitorColumnConfigSetting(columnName, settingName);
        return value instanceof String ? (String)value : null;
    }

    protected Boolean getMonitorColumnConfigBooleanSetting(String columnName, String settingName) {
        Object value = this.getMonitorColumnConfigSetting(columnName, settingName);
        return value instanceof Boolean ? (Boolean)value : Boolean.FALSE;
    }

    protected Map getMonitorColumnConfigMapSetting(String columnName, String settingName) {
        Object value = this.getMonitorColumnConfigSetting(columnName, settingName);
        return value instanceof Map ? (Map)value : null;
    }

    protected Date getDateFromValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        try {
            return Date.from(ZonedDateTime.parse(value.toString()).toInstant());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not parse the date: " + value, ex);
            return null;
        }
    }

    protected Map<String, Object> getOpenSearchMappingFieldConfig(String columnName) {
        return this.openSearchColumnsMapping.get(columnName);
    }

    protected String getOpenSearchColumnType(String columnName) {
        return this.columnTypes.get(columnName);
    }

    protected ArrayList<MonitorDataExportColumn> getMonitorDataExportColumns(boolean useCustomColumnHeaders) {
        ArrayList<MonitorDataExportColumn> result = new ArrayList<MonitorDataExportColumn>();
        for (String columnName : this.columnNames) {
            String columnLanguageKey;
            Map localizedMap;
            String customColumnName = null;
            if (this.translationsForBpcLanguage != null && (localizedMap = this.getMonitorColumnConfigMapSetting(columnName, "localized")) != null && localizedMap.containsKey("text") && (columnLanguageKey = (String)localizedMap.get("text")) != null) {
                String translatedColumnName = (String)this.translationsForBpcLanguage.get(columnLanguageKey);
                String string = customColumnName = translatedColumnName != null ? translatedColumnName : columnLanguageKey;
            }
            if (customColumnName == null) {
                customColumnName = this.getMonitorColumnConfigStringSetting(columnName, "text");
            }
            if (!useCustomColumnHeaders || customColumnName == null) {
                result.add(new MonitorDataExportColumn(columnName, columnName));
                continue;
            }
            result.add(new MonitorDataExportColumn(columnName, customColumnName));
        }
        return result;
    }

    protected class MonitorDataExportColumn {
        private String columnName;
        private String columnNameForExport;

        public MonitorDataExportColumn(String columnName, String columnNameForExport) {
            this.columnName = columnName;
            this.columnNameForExport = columnNameForExport;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getColumnNameForExport() {
            return this.columnNameForExport;
        }
    }
}

