/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.WebSocket;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class BpcConnection
implements OpenSearchPluginDTO {
    private static final Logger LOG = Loggers.getLogger(BpcConnection.class, (String[])new String[]{"os-bpc-plugin"});
    private String connectedNode;
    private String websocketId;
    private WebSocket webSocket;
    private ServerStateInfoDTO serverStateInfo;
    private LoadedModulesDTO serverLoadedModules;
    private Instant modifiedAtInUtc;

    private BpcConnection() {
    }

    public BpcConnection(String connectedNode, String websocketId) {
        Objects.requireNonNull(connectedNode, "'connectedNode' must not be null");
        Objects.requireNonNull(websocketId, "'websocketId' must not be null");
        this.connectedNode = connectedNode;
        this.websocketId = websocketId;
        this.webSocket = null;
        this.serverStateInfo = null;
        this.serverLoadedModules = null;
        this.modifiedAtInUtc = TimestampUtil.nowInUtc();
    }

    public BpcConnection(String connectedNode, WebSocket webSocket) {
        Objects.requireNonNull(connectedNode, "'connectedNode' must not be null");
        Objects.requireNonNull(webSocket, "'webSocket' must not be null");
        this.connectedNode = connectedNode;
        this.websocketId = webSocket.getId();
        this.webSocket = webSocket;
        this.serverStateInfo = null;
        this.serverLoadedModules = null;
        this.modifiedAtInUtc = TimestampUtil.nowInUtc();
    }

    public BpcConnection(Map<String, Object> map) {
        this.connectedNode = MapUtil.getValueAsString(map, (String)"connectedNode", null);
        this.websocketId = MapUtil.getValueAsString(map, (String)"websocketId", null);
        this.webSocket = null;
        this.serverStateInfo = map.get("serverStateInfo") instanceof Map ? new ServerStateInfoDTO((Map)map.get("serverStateInfo")) : null;
        this.serverLoadedModules = map.get("serverLoadedModules") instanceof List ? new LoadedModulesDTO((List)map.get("serverLoadedModules")) : null;
        this.modifiedAtInUtc = MapUtil.getValueAsInstant(map, (String)"modifiedAt", (Instant)TimestampUtil.nowInUtc());
    }

    public BpcConnection(StreamInput in) throws IOException {
        this.connectedNode = in.readString();
        this.websocketId = in.readString();
        this.webSocket = null;
        this.serverStateInfo = (ServerStateInfoDTO)in.readOptionalWriteable(ServerStateInfoDTO::new);
        this.serverLoadedModules = (LoadedModulesDTO)in.readOptionalWriteable(LoadedModulesDTO::new);
        this.modifiedAtInUtc = in.readInstant();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.connectedNode);
        out.writeString(this.websocketId);
        out.writeOptionalWriteable((Writeable)this.serverStateInfo);
        out.writeOptionalWriteable((Writeable)this.serverLoadedModules);
        out.writeInstant(this.modifiedAtInUtc);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("connectedNode", this.connectedNode);
        builder.field("websocketId", this.websocketId);
        if (this.serverStateInfo != null) {
            builder.field("serverStateInfo", (ToXContent)this.serverStateInfo, params);
        }
        if (this.serverLoadedModules != null) {
            builder.field("serverLoadedModules", (ToXContent)this.serverLoadedModules, params);
        }
        builder.field("modifiedAt", TimestampUtil.formatAsIsoInstantString((Instant)this.modifiedAtInUtc));
        builder.endObject();
        return builder;
    }

    public static BpcConnection fromXContent(XContentParser parser) throws IOException {
        return new BpcConnection(parser.map());
    }

    public String getConnectedNode() {
        return this.connectedNode;
    }

    public String getWebsocketId() {
        return this.websocketId;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public boolean hasServerStateInfo() {
        return this.serverStateInfo != null;
    }

    public ServerStateInfoDTO getServerStateInfo() {
        return this.serverStateInfo;
    }

    public boolean setServerStateInfo(ServerStateInfoDTO serverStateInfo) {
        if (this.serverStateInfo == null && serverStateInfo == null) {
            return false;
        }
        if (this.serverStateInfo != null && serverStateInfo != null && this.serverStateInfo.equals((Object)serverStateInfo)) {
            return false;
        }
        this.serverStateInfo = serverStateInfo;
        this.modifiedAtInUtc = TimestampUtil.nowInUtc();
        return true;
    }

    public boolean hasServerLoadedModules() {
        return this.serverLoadedModules != null && !this.serverLoadedModules.isEmpty();
    }

    public LoadedModulesDTO getServerLoadedModules() {
        return this.serverLoadedModules;
    }

    public boolean setServerLoadedModules(LoadedModulesDTO serverLoadedModules) {
        if (this.serverLoadedModules == null && serverLoadedModules == null) {
            return false;
        }
        if (this.serverLoadedModules != null && serverLoadedModules != null && this.serverLoadedModules.equals((Object)serverLoadedModules)) {
            return false;
        }
        this.serverLoadedModules = serverLoadedModules;
        this.modifiedAtInUtc = TimestampUtil.nowInUtc();
        return true;
    }

    public Instant getModifiedAtInUtc() {
        return this.modifiedAtInUtc;
    }

    public LocalDateTime getModifiedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.modifiedAtInUtc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BpcConnection that = (BpcConnection)o;
        return Objects.equals(this.connectedNode, that.connectedNode) && Objects.equals(this.websocketId, that.websocketId) && Objects.equals(this.webSocket, that.webSocket) && Objects.equals(this.serverStateInfo, that.serverStateInfo) && Objects.equals(this.serverLoadedModules, that.serverLoadedModules) && Objects.equals(this.modifiedAtInUtc, that.modifiedAtInUtc);
    }

    public int hashCode() {
        return Objects.hash(this.connectedNode, this.websocketId);
    }

    public String toString() {
        return "BpcConnection{connectedNode='" + this.connectedNode + "', websocketId='" + this.websocketId + "', webSocket=" + this.webSocket + ", serverStateInfo=" + this.serverStateInfo + ", serverLoadedModules=" + this.serverLoadedModules + ", modifiedAtInUtc=" + this.modifiedAtInUtc + "}";
    }
}

