/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.BpcConnection;
import de.virtimo.bpc.opensearch.plugin.BpcConnections;
import de.virtimo.bpc.opensearch.plugin.BpcPlugin;
import de.virtimo.bpc.opensearch.plugin.BpcPluginModelInitDTO;
import de.virtimo.bpc.opensearch.plugin.ChangesFilter;
import de.virtimo.bpc.opensearch.plugin.ChangesFilters;
import de.virtimo.bpc.opensearch.plugin.ClusterObserver;
import de.virtimo.bpc.opensearch.plugin.MasterServerInfo;
import de.virtimo.bpc.opensearch.plugin.NodesInfo;
import de.virtimo.bpc.opensearch.plugin.WebSocket;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterAddActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveAllActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetResponse;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllExceptSenderWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexCreatedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexDeletedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexOperationWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.PlainTextWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerLoadedModulesWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerStateInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.SetAsMasterServerWebsocketMessage;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.websocket.DeploymentException;
import org.apache.logging.log4j.Logger;
import org.glassfish.tyrus.server.Server;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.component.AbstractLifecycleComponent;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.engine.Engine;

public class Manager
extends AbstractLifecycleComponent {
    private static final Logger LOG = Loggers.getLogger(Manager.class, (String[])new String[]{"os-bpc-plugin"});
    private final Client client;
    private final ClusterService clusterService;
    private final NodesInfo nodesInfo;
    private final ClusterObserver clusterObserver;
    private MasterServerInfo masterServerInfo;
    private BpcConnections connections;
    private ChangesFilters changesFilters;
    private final int websocketServerPort;
    private final Server websocketServer;
    private static final Object MASTER_SERVER_LOCK = new Object();

    public Manager(Client client, ClusterService clusterService, Settings settings) {
        LOG.debug("Manager client=" + client + ", clusterService=" + clusterService + ", settings=" + settings);
        this.client = client;
        this.clusterService = clusterService;
        this.nodesInfo = new NodesInfo(client, clusterService);
        this.clusterObserver = new ClusterObserver(clusterService, this);
        this.masterServerInfo = null;
        this.connections = new BpcConnections();
        this.changesFilters = new ChangesFilters();
        this.websocketServerPort = BpcPlugin.getSettingsValueAsInt(settings, "os-bpc-plugin.websocket.port", BpcPlugin.DEFAULT_WEBSOCKET_PORT);
        this.websocketServer = new Server("localhost", this.websocketServerPort, "/ws", MapUtil.mapOf((Object[])new Object[]{"manager", this}), new Class[]{WebSocket.class});
    }

    protected void doStart() {
        try {
            LOG.info("Starting WebSocket server");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        Manager.this.websocketServer.start();
                        return null;
                    }
                    catch (DeploymentException e) {
                        throw new RuntimeException("Failed to start server", e);
                    }
                }
            });
            LOG.info("WebSocket server started");
        }
        catch (Exception e) {
            LOG.error("Failed to start WebSocket server. Please restart OpenSearch to try it again or check why it is not possible to start a websocket server on port '" + this.websocketServerPort + "'.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.clusterObserver.doStart();
        }
        catch (Exception ex) {
            LOG.error("Failed to start the cluster observer.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected void doStop() {
        this.websocketServer.stop();
        this.clusterObserver.doStop();
    }

    protected void doClose() throws IOException {
    }

    public void initializePluginModel(String sendFromOpenSearchNode, BpcPluginModelInitDTO initPluginModelDTO) {
        LOG.info("initializePluginModel sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", initPluginModelDTO=" + initPluginModelDTO);
        this.masterServerInfo = initPluginModelDTO.getMasterServerInfo();
        this.connections = initPluginModelDTO.getConnections();
        this.changesFilters = initPluginModelDTO.getChangesFilters();
    }

    public NodesInfo getNodesInfo() {
        return this.nodesInfo;
    }

    public MasterServerInfo getMasterServerInfo() {
        return this.masterServerInfo;
    }

    public BpcConnections getConnections() {
        return this.connections;
    }

    public ChangesFilters getChangesFilters() {
        return this.changesFilters;
    }

    public void registerWebSocket(WebSocket webSocket) {
        LOG.debug("registerWebSocket webSocket=" + webSocket);
        String thisNodeName = this.nodesInfo.getLocalNodeName();
        BpcConnection connection = this.connections.addConnection(thisNodeName, webSocket);
        this.client.execute((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, (ActionRequest)new BpcConnectionAddedOrUpdatedRequest(thisNodeName, connection), (ActionListener)new ActionListener<BpcConnectionAddedOrUpdatedResponse>(){

            public void onResponse(BpcConnectionAddedOrUpdatedResponse bpcConnectionAddedOrUpdatedResponse) {
                if (bpcConnectionAddedOrUpdatedResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a BPC connection added message to all nodes.", (Throwable)bpcConnectionAddedOrUpdatedResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a BPC connection added message to all nodes. Response: " + bpcConnectionAddedOrUpdatedResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast a BPC connection added message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void unregisterWebSocket(String webSocketId) {
        LOG.debug("unregisterWebSocket webSocketId=" + webSocketId);
        BpcConnection existingConnection = this.connections.getConnectionByWebsocketId(webSocketId);
        this._unregisterConnection(existingConnection);
    }

    private void _unregisterConnection(BpcConnection existingConnection) {
        LOG.info("_unregisterConnection existingConnection=" + existingConnection);
        if (existingConnection != null) {
            this.client.execute((ActionType)BpcConnectionRemovedAction.INSTANCE, (ActionRequest)new BpcConnectionRemovedRequest(this.nodesInfo.getLocalNodeName(), existingConnection), (ActionListener)new ActionListener<BpcConnectionRemovedResponse>(){

                public void onResponse(BpcConnectionRemovedResponse bpcConnectionRemovedResponse) {
                    if (bpcConnectionRemovedResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a BPC connection removed message to all nodes.", (Throwable)bpcConnectionRemovedResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a BPC connection removed message to all nodes. Response: " + bpcConnectionRemovedResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a BPC connection removed message to all nodes.", (Throwable)ex);
                }
            });
        }
    }

    public void unregisterRemovedOpenSearchNodes(Set<String> namesOfRemovedNodes) {
        LOG.debug("unregisterRemovedOpenSearchNodes namesOfRemovedNodes=" + namesOfRemovedNodes);
        List<BpcConnection> connectionsToUnregister = this.connections.getConnectionsByOpenSearchNodeNames(namesOfRemovedNodes);
        for (BpcConnection connectionToUnregister : connectionsToUnregister) {
            this._unregisterConnection(connectionToUnregister);
        }
    }

    public void handleJustAddedOpenSearchNodes(List<DiscoveryNode> addedNodes) {
        LOG.debug("handleJustAddedOpenSearchNodes addedNodes=" + addedNodes);
        this.nodesInfo.ifThisNodeIsTheMasterNodeOrElse(() -> this._handleJustAddedOpenSearchNodes(addedNodes), () -> LOG.debug("Skipping, the plugin model initialization must be processed on the master node only."));
    }

    public void _handleJustAddedOpenSearchNodes(List<DiscoveryNode> addedNodes) {
        LOG.debug("_handleJustAddedOpenSearchNodes addedNodes=" + addedNodes);
        BpcPluginModelInitDTO initPluginModelDTO = new BpcPluginModelInitDTO(this.masterServerInfo, this.connections, this.changesFilters);
        this.client.execute((ActionType)InitializeModelAction.INSTANCE, (ActionRequest)new InitializeModelRequest(this.nodesInfo.getLocalNodeName(), addedNodes, initPluginModelDTO), (ActionListener)new ActionListener<InitializeModelResponse>(){

            public void onResponse(InitializeModelResponse initializeModelResponse) {
                if (initializeModelResponse.hasFailures()) {
                    LOG.error("Failed to broadcast the initialize model message to the just added nodes.", (Throwable)initializeModelResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting the initialize model message to the just added nodes. Response: " + initializeModelResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast the init plugin model message to the just added nodes.", (Throwable)ex);
            }
        });
    }

    public void processReceivedServerStateInfoWebsocketMessage(String websocketId, ServerStateInfoWebsocketMessage serverStateInfoWebsocketMessage) {
        LOG.debug("processReceivedServerStateInfoWebsocketMessage websocketId=" + websocketId + ", serverStateInfoWebsocketMessage=" + serverStateInfoWebsocketMessage);
        BpcConnection connection = this.connections.getConnectionByWebsocketId(websocketId);
        if (connection != null) {
            ServerStateInfoDTO serverStateInfo = serverStateInfoWebsocketMessage.getServerStateInfo();
            connection.setServerStateInfo(serverStateInfo);
            this.client.execute((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, (ActionRequest)new BpcConnectionAddedOrUpdatedRequest(this.nodesInfo.getLocalNodeName(), connection), (ActionListener)new ActionListener<BpcConnectionAddedOrUpdatedResponse>(){

                public void onResponse(BpcConnectionAddedOrUpdatedResponse bpcConnectionAddedOrUpdatedResponse) {
                    if (bpcConnectionAddedOrUpdatedResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)bpcConnectionAddedOrUpdatedResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a BPC connection updated message to all nodes. Response: " + bpcConnectionAddedOrUpdatedResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)ex);
                }
            });
        } else {
            LOG.warn("There must be something wrong. Received a server state info websocket message, but there is no websocket session registered on this node.");
        }
    }

    public void processReceivedServerLoadedModulesWebsocketMessage(String websocketId, ServerLoadedModulesWebsocketMessage serverLoadedModulesWebsocketMessage) {
        LOG.debug("processReceivedServerLoadedModulesWebsocketMessage websocketId=" + websocketId + ", serverLoadedModulesWebsocketMessage=" + serverLoadedModulesWebsocketMessage);
        BpcConnection connection = this.connections.getConnectionByWebsocketId(websocketId);
        if (connection != null) {
            LoadedModulesDTO serverLoadedModules = serverLoadedModulesWebsocketMessage.getServerLoadedModules();
            connection.setServerLoadedModules(serverLoadedModules);
            this.client.execute((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, (ActionRequest)new BpcConnectionAddedOrUpdatedRequest(this.nodesInfo.getLocalNodeName(), connection), (ActionListener)new ActionListener<BpcConnectionAddedOrUpdatedResponse>(){

                public void onResponse(BpcConnectionAddedOrUpdatedResponse bpcConnectionAddedOrUpdatedResponse) {
                    if (bpcConnectionAddedOrUpdatedResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)bpcConnectionAddedOrUpdatedResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a BPC connection updated message to all nodes. Response: " + bpcConnectionAddedOrUpdatedResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)ex);
                }
            });
        } else {
            LOG.warn("There must be something wrong. Received a server loaded modules websocket message, but there is no websocket session registered on this node.");
        }
    }

    private void setNextAvailableServerAsMaster(ActionListener<MasterServerInfo> afterExecution) {
        String nextServerUUID;
        LOG.debug("setNextAvailableServerAsMaster afterExecution=...");
        ServerStateInfoDTO serverStateInfo = this.connections.evaluateNextAvailableMasterServer();
        if (serverStateInfo != null) {
            LOG.debug("setNextAvailableServerAsMaster serverStateInfo=" + serverStateInfo);
            nextServerUUID = serverStateInfo.getServerUUID();
        } else {
            LOG.info("setNextAvailableServerAsMaster: There is no BPC server available");
            nextServerUUID = "<<NONE>>";
        }
        this.setAsMasterServer(nextServerUUID, afterExecution);
    }

    public void setAsMasterServer(String masterServerUUID, final ActionListener<MasterServerInfo> afterExecution) {
        LOG.debug("setAsMasterServer masterServerUUID=" + masterServerUUID + ", afterExecution=" + afterExecution);
        final MasterServerInfo masterServerInfo = new MasterServerInfo(masterServerUUID);
        this.client.execute((ActionType)MasterServerSetAction.INSTANCE, (ActionRequest)new MasterServerSetRequest(this.nodesInfo.getLocalNodeName(), masterServerInfo), (ActionListener)new ActionListener<MasterServerSetResponse>(){

            public void onResponse(MasterServerSetResponse masterServerSetResponse) {
                if (afterExecution != null) {
                    if (masterServerSetResponse.hasFailures()) {
                        OpenSearchException aggregatedException = masterServerSetResponse.createAggregatedException();
                        LOG.error("Failed to set master server on all nodes.", (Throwable)aggregatedException);
                        afterExecution.onFailure((Exception)aggregatedException);
                    } else {
                        afterExecution.onResponse((Object)masterServerInfo);
                    }
                } else if (masterServerSetResponse.hasFailures()) {
                    LOG.error("Failed to set master server on all nodes.", (Throwable)masterServerSetResponse.createAggregatedException());
                }
            }

            public void onFailure(Exception ex) {
                if (afterExecution != null) {
                    afterExecution.onFailure(ex);
                } else {
                    LOG.error("Failed to broadcast the master server info message to all nodes.", (Throwable)ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMasterServerInfoSetting(String sendFromOpenSearchNode, MasterServerInfo masterServerInfo) {
        LOG.debug("processMasterServerInfoSetting sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", masterServerInfo=" + masterServerInfo);
        Object object = MASTER_SERVER_LOCK;
        synchronized (object) {
            if (masterServerInfo == null || !masterServerInfo.isMasterServerSet()) {
                LOG.info("No more BPC master server");
                this.masterServerInfo = null;
            } else if (this.masterServerInfo == null || !this.masterServerInfo.getServerUUID().equals(masterServerInfo.getServerUUID())) {
                LOG.info("Setting the BPC server with the following UUID as master: " + masterServerInfo.getServerUUID());
                this.masterServerInfo = masterServerInfo;
                SetAsMasterServerWebsocketMessage setAsMasterServerWebsocketMessage = new SetAsMasterServerWebsocketMessage(masterServerInfo.getServerUUID());
                this.connections.sendWebsocketMessage((WebsocketMessage)setAsMasterServerWebsocketMessage, null);
            } else {
                LOG.info("The BPC server with the following UUID is already set as master: " + masterServerInfo.getServerUUID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAddedOrUpdatedConnection(String sendFromOpenSearchNode, BpcConnection connection) {
        LOG.debug("processAddedOrUpdatedConnection sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", connection=" + connection);
        if (connection != null) {
            this.connections.addOrUpdateConnection(connection);
            Object object = MASTER_SERVER_LOCK;
            synchronized (object) {
                if (this.masterServerInfo == null && connection.hasServerStateInfo()) {
                    this.nodesInfo.ifThisNodeIsTheMasterNode(() -> this.setNextAvailableServerAsMaster(new ActionListener<MasterServerInfo>(){

                        public void onResponse(MasterServerInfo masterServerInfo) {
                            LOG.info("'" + masterServerInfo.getServerUUID() + "' has been set as the new master server (processAddedOrUpdatedConnection).");
                        }

                        public void onFailure(Exception ex) {
                            LOG.error("Failed to set next available server as the new master server (processAddedOrUpdatedConnection).", (Throwable)ex);
                        }
                    }));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemovedConnection(String sendFromOpenSearchNode, BpcConnection connection) {
        LOG.info("processRemovedConnection sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", connection=" + connection);
        if (connection != null) {
            BpcConnection existingConnection;
            String unregisteredServerUUID;
            ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
            String string = unregisteredServerUUID = serverStateInfo != null ? serverStateInfo.getServerUUID() : null;
            if (unregisteredServerUUID != null) {
                ChangesFilterRemoveAllActionDTO removeAllFiltersAction = new ChangesFilterRemoveAllActionDTO(unregisteredServerUUID);
                this.removeAllChangesFilters(removeAllFiltersAction, true);
            }
            if ((existingConnection = this.connections.getConnectionByWebsocketId(connection.getWebsocketId())) != null) {
                this.connections.removeConnection(existingConnection);
            }
            Object object = MASTER_SERVER_LOCK;
            synchronized (object) {
                if (this.masterServerInfo == null || this.masterServerInfo.getServerUUID().equals(unregisteredServerUUID)) {
                    this.nodesInfo.ifThisNodeIsTheMasterNode(() -> this.setNextAvailableServerAsMaster(new ActionListener<MasterServerInfo>(){

                        public void onResponse(MasterServerInfo masterServerInfo) {
                            LOG.info("'" + masterServerInfo.getServerUUID() + "' has been set as the new master server (processRemovedConnection).");
                        }

                        public void onFailure(Exception ex) {
                            LOG.error("Failed to set next available server as the new master server (processRemovedConnection).", (Throwable)ex);
                        }
                    }));
                }
            }
        }
    }

    public void addChangesFilter(ChangesFilterAddActionDTO addFilterAction, boolean informOtherNodes) {
        List<DiscoveryNode> allOtherNodes;
        LOG.debug("addChangesFilter addFilterAction=" + addFilterAction + ", informOtherNodes=" + informOtherNodes);
        boolean added = this.changesFilters.add(addFilterAction.getServerUUID(), addFilterAction.getIndex(), addFilterAction.isSendIndexEventsOnlyForModifiedSources());
        if (added && informOtherNodes && !(allOtherNodes = this.nodesInfo.getAllOtherNodes()).isEmpty()) {
            this.client.execute((ActionType)ChangesFilterAddAction.INSTANCE, (ActionRequest)new ChangesFilterAddRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, addFilterAction), (ActionListener)new ActionListener<ChangesFilterAddResponse>(){

                public void onResponse(ChangesFilterAddResponse changesFilterAddResponse) {
                    if (changesFilterAddResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a add changes filter message to all other nodes.", (Throwable)changesFilterAddResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a add changes filter message to all other nodes. Response: " + changesFilterAddResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a add changes filter message to all other nodes.", (Throwable)ex);
                }
            });
        }
    }

    public void removeAllChangesFilters(ChangesFilterRemoveAllActionDTO removeAllFilterAction, boolean informOtherNodes) {
        List<DiscoveryNode> allOtherNodes;
        LOG.debug("removeAllChangesFilters removeAllFilterAction=" + removeAllFilterAction + ", informOtherNodes=" + informOtherNodes);
        if (this.changesFilters.removeAll(removeAllFilterAction.getServerUUID()) && informOtherNodes && !(allOtherNodes = this.nodesInfo.getAllOtherNodes()).isEmpty()) {
            this.client.execute((ActionType)ChangesFilterRemoveAllAction.INSTANCE, (ActionRequest)new ChangesFilterRemoveAllRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, removeAllFilterAction), (ActionListener)new ActionListener<ChangesFilterRemoveAllResponse>(){

                public void onResponse(ChangesFilterRemoveAllResponse changesFilterRemoveAllResponse) {
                    if (changesFilterRemoveAllResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a remove all changes filters message to all other nodes.", (Throwable)changesFilterRemoveAllResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a remove all changes filters message to all other nodes. Response: " + changesFilterRemoveAllResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a remove all changes filters message to all other nodes.", (Throwable)ex);
                }
            });
        }
    }

    public boolean removeChangesFilter(ChangesFilterRemoveActionDTO removeFilterAction, boolean informOtherNodes) {
        List<DiscoveryNode> allOtherNodes;
        LOG.debug("removeChangesFilter removeFilterAction=" + removeFilterAction + ", informOtherNodes=" + informOtherNodes);
        boolean removed = this.changesFilters.remove(removeFilterAction.getServerUUID(), removeFilterAction.getIndex());
        if (removed && informOtherNodes && !(allOtherNodes = this.nodesInfo.getAllOtherNodes()).isEmpty()) {
            this.client.execute((ActionType)ChangesFilterRemoveAction.INSTANCE, (ActionRequest)new ChangesFilterRemoveRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, removeFilterAction), (ActionListener)new ActionListener<ChangesFilterRemoveResponse>(){

                public void onResponse(ChangesFilterRemoveResponse changesFilterRemoveResponse) {
                    if (changesFilterRemoveResponse.hasFailures()) {
                        LOG.error("Failed to broadcast a remove changes filter message to all other nodes.", (Throwable)changesFilterRemoveResponse.createAggregatedException());
                    } else {
                        LOG.debug("Done broadcasting a remove changes filter message to all other nodes. Response: " + changesFilterRemoveResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to broadcast a remove changes filter message to all other nodes.", (Throwable)ex);
                }
            });
        }
        return removed;
    }

    public void processAddChangesFilterActionDTO(String sendFromOpenSearchNode, ChangesFilterAddActionDTO addFilterActionDTO) {
        LOG.debug("processAddChangesFilterActionDTO sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", addFilterActionDTO=" + addFilterActionDTO);
        this.addChangesFilter(addFilterActionDTO, false);
    }

    public void processRemoveAllChangesFilterActionDTO(String sendFromOpenSearchNode, ChangesFilterRemoveAllActionDTO removeAllFilterActionDTO) {
        LOG.debug("processRemoveAllChangesFilterActionDTO sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", removeAllFilterActionDTO=" + removeAllFilterActionDTO);
        this.removeAllChangesFilters(removeAllFilterActionDTO, false);
    }

    public void processRemoveChangesFilterActionDTO(String sendFromOpenSearchNode, ChangesFilterRemoveActionDTO removeFilterActionDTO) {
        LOG.debug("processRemoveChangesFilterActionDTO sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", removeFilterActionDTO=" + removeFilterActionDTO);
        this.removeChangesFilter(removeFilterActionDTO, false);
    }

    private Set<String> getAliasesOfIndex(String indexName) {
        return new HashSet<String>(Arrays.asList((String[])this.clusterService.state().metadata().index(indexName).getAliases().keys().toArray(String.class)));
    }

    public void onIndexDeleted(String indexName) {
        LOG.debug("onIndexDeleted indexName=" + indexName);
        if (this.connections.hasEntries()) {
            IndexDeletedWebsocketMessage indexDeletedWebsocketMessage = new IndexDeletedWebsocketMessage(indexName);
            this.connections.sendWebsocketMessage((WebsocketMessage)indexDeletedWebsocketMessage, null);
        }
    }

    public void onIndexCreated(String indexName) {
        LOG.debug("onIndexCreated indexName=" + indexName);
        if (this.connections.hasEntries()) {
            IndexCreatedWebsocketMessage indexCreatedWebsocketMessage = new IndexCreatedWebsocketMessage(indexName);
            this.connections.sendWebsocketMessage((WebsocketMessage)indexCreatedWebsocketMessage, null);
        }
    }

    public Map<Engine.Index, Boolean> onPreIndexDocumentOperation(String indexName, Engine.Index index, Map<Engine.Index, Boolean> identicalSourcesMap) {
        LOG.debug("onPreIndexDocumentOperation indexName=" + indexName + ", index=..., identicalSourcesMap=" + identicalSourcesMap);
        if (this.connections.hasEntries()) {
            Set<String> aliasesOfIndex = this.getAliasesOfIndex(indexName);
            String documentId = index.id();
            ChangesFilter filter = this.changesFilters.getFilter(indexName, aliasesOfIndex);
            if (filter != null && filter.isSendIndexEventsOnlyForModifiedSources()) {
                Map currentSource = null;
                try {
                    currentSource = JsonUtil.asMap((BytesReference)index.source());
                }
                catch (IOException ex) {
                    LOG.error("Failed to convert the OpenSearch SOURCE as JSON. This should not be possible. Index: " + indexName + ", ID: " + documentId, (Throwable)ex);
                }
                Map previousSource = null;
                try {
                    GetResponse getResponse = (GetResponse)this.client.prepareGet(indexName, documentId).execute().actionGet();
                    if (getResponse != null) {
                        previousSource = getResponse.getSource();
                    }
                }
                catch (Exception ex) {
                    LOG.error("Could not get the current document.", (Throwable)ex);
                }
                boolean identicalSources = currentSource == null && previousSource == null ? true : (currentSource != null && previousSource == null ? false : (currentSource == null && previousSource != null ? false : currentSource.equals(previousSource)));
                if (identicalSourcesMap == null) {
                    identicalSourcesMap = new HashMap<Engine.Index, Boolean>();
                }
                identicalSourcesMap.put(index, identicalSources);
            }
        }
        return identicalSourcesMap;
    }

    public void onPostIndexDocumentOperation(String indexName, Engine.Index index, Map<Engine.Index, Boolean> identicalSourcesMap) {
        Set<String> aliasesOfIndex;
        ChangesFilter filter;
        LOG.debug("onPostIndexDocumentOperation indexName=" + indexName + ", index=..., identicalSourcesMap=..." + identicalSourcesMap);
        if (this.connections.hasEntries() && (filter = this.changesFilters.getFilter(indexName, aliasesOfIndex = this.getAliasesOfIndex(indexName))) != null) {
            boolean sendChangesEvent;
            if (filter.isSendIndexEventsOnlyForModifiedSources()) {
                if (identicalSourcesMap != null) {
                    boolean identicalSources = identicalSourcesMap.get(index);
                    identicalSourcesMap.remove(index);
                    sendChangesEvent = !identicalSources;
                } else {
                    sendChangesEvent = false;
                }
            } else {
                sendChangesEvent = true;
            }
            if (sendChangesEvent) {
                IndexOperationDTO indexOperation = new IndexOperationDTO(indexName, aliasesOfIndex, index.id(), IndexOperationDTO.Operation.INDEX, index.version(), (Map)XContentHelper.convertToMap((BytesReference)index.source(), (boolean)false, (XContentType)XContentType.JSON).v2());
                this.processIndexOperation(indexOperation);
            }
        }
    }

    public void onDeleteDocumentOperation(String indexName, String documentId, long documentVersion) {
        Set<String> aliasesOfIndex;
        ChangesFilter filter;
        LOG.debug("onDeleteDocumentOperation indexName=" + indexName + ", documentId=" + documentId + ", documentVersion=" + documentVersion);
        if (this.connections.hasEntries() && (filter = this.changesFilters.getFilter(indexName, aliasesOfIndex = this.getAliasesOfIndex(indexName))) != null) {
            IndexOperationDTO indexOperation = new IndexOperationDTO(indexName, aliasesOfIndex, documentId, IndexOperationDTO.Operation.DELETE, documentVersion, null);
            this.processIndexOperation(indexOperation);
        }
    }

    private void processIndexOperation(IndexOperationDTO indexOperation) {
        LOG.debug("processIndexOperation indexOperation=" + indexOperation);
        this.client.execute((ActionType)IndexOperationAction.INSTANCE, (ActionRequest)new IndexOperationRequest(this.nodesInfo.getLocalNodeName(), indexOperation), (ActionListener)new ActionListener<IndexOperationResponse>(){

            public void onResponse(IndexOperationResponse indexOperationResponse) {
                if (indexOperationResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a index operation message to all nodes.", (Throwable)indexOperationResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a index operation message to all nodes. Response: " + indexOperationResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast an IndexOperation to all nodes.", (Throwable)ex);
            }
        });
    }

    public void sendIndexOperationToConnectedServers(String sendFromOpenSearchNode, IndexOperationDTO indexOperation) {
        LOG.debug("sendIndexOperationToConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", indexOperation=" + indexOperation);
        IndexOperationWebsocketMessage indexOperationWebsocketMessage = new IndexOperationWebsocketMessage(indexOperation);
        this.connections.sendWebsocketMessage((WebsocketMessage)indexOperationWebsocketMessage, null);
    }

    public void processReceivedBroadcastToAllWebsocketMessage(String websocketId, String serverUUID, BroadcastToAllWebsocketMessage websocketMessage) {
        LOG.debug("processReceivedBroadcastToAllWebsocketMessage websocketId=" + websocketId + ", serverUUID=" + serverUUID + ", websocketMessage=" + websocketMessage);
        this.client.execute((ActionType)BroadcastReceivedWebsocketMessageToAllAction.INSTANCE, (ActionRequest)new BroadcastReceivedWebsocketMessageToAllRequest(this.nodesInfo.getLocalNodeName(), websocketId, serverUUID, websocketMessage), (ActionListener)new ActionListener<BroadcastReceivedWebsocketMessageToAllResponse>(){

            public void onResponse(BroadcastReceivedWebsocketMessageToAllResponse broadcastReceivedWebsocketMessageToAllResponse) {
                if (broadcastReceivedWebsocketMessageToAllResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)broadcastReceivedWebsocketMessageToAllResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a received websocket message to all nodes. Response: " + broadcastReceivedWebsocketMessageToAllResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void forwardWebsocketMessageToConnectedServers(String sendFromOpenSearchNode, BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage) {
        LOG.debug("forwardWebsocketMessageToConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", broadcastToAllWebsocketMessage=" + broadcastToAllWebsocketMessage);
        PlainTextWebsocketMessage websocketMessageToSend = new PlainTextWebsocketMessage(broadcastToAllWebsocketMessage.getMessage());
        this.connections.sendWebsocketMessage((WebsocketMessage)websocketMessageToSend, null);
    }

    public void processReceivedBroadcastToAllExceptSenderWebsocketMessage(String websocketId, String serverUUID, BroadcastToAllExceptSenderWebsocketMessage websocketMessage) {
        LOG.debug("processReceivedBroadcastToAllExceptSenderWebsocketMessage websocketId=" + websocketId + ", serverUUID=" + serverUUID + ", websocketMessage=" + websocketMessage);
        this.client.execute((ActionType)BroadcastReceivedWebsocketMessageToAllExceptSenderAction.INSTANCE, (ActionRequest)new BroadcastReceivedWebsocketMessageToAllExceptSenderRequest(this.nodesInfo.getLocalNodeName(), websocketId, serverUUID, websocketMessage), (ActionListener)new ActionListener<BroadcastReceivedWebsocketMessageToAllExceptSenderResponse>(){

            public void onResponse(BroadcastReceivedWebsocketMessageToAllExceptSenderResponse broadcastReceivedWebsocketMessageToAllExceptSenderResponse) {
                if (broadcastReceivedWebsocketMessageToAllExceptSenderResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)broadcastReceivedWebsocketMessageToAllExceptSenderResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a received websocket message to all nodes. Response: " + broadcastReceivedWebsocketMessageToAllExceptSenderResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to send a broadcast to all except sender websocket message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void forwardWebsocketMessageToConnectedServers(String sendFromOpenSearchNode, BroadcastToAllExceptSenderWebsocketMessage websocketMessage, String senderServerUUID) {
        LOG.debug("forwardWebsocketMessageToConnectedServers sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", websocketMessage=" + websocketMessage + ", senderServerUUID=" + senderServerUUID);
        PlainTextWebsocketMessage websocketMessageToSend = new PlainTextWebsocketMessage(websocketMessage.getMessage());
        this.connections.sendWebsocketMessage((WebsocketMessage)websocketMessageToSend, Collections.singletonList(senderServerUUID));
    }

    public void processReceivedBroadcastToWebsocketMessage(String websocketId, String serverUUID, BroadcastToWebsocketMessage websocketMessage) {
        LOG.debug("processReceivedBroadcastToWebsocketMessage websocketId=" + websocketId + ", serverUUID=" + serverUUID + ", websocketMessage=" + websocketMessage);
        this.client.execute((ActionType)BroadcastReceivedWebsocketMessageToAction.INSTANCE, (ActionRequest)new BroadcastReceivedWebsocketMessageToRequest(this.nodesInfo.getLocalNodeName(), websocketId, serverUUID, websocketMessage), (ActionListener)new ActionListener<BroadcastReceivedWebsocketMessageToResponse>(){

            public void onResponse(BroadcastReceivedWebsocketMessageToResponse broadcastReceivedWebsocketMessageToResponse) {
                if (broadcastReceivedWebsocketMessageToResponse.hasFailures()) {
                    LOG.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)broadcastReceivedWebsocketMessageToResponse.createAggregatedException());
                } else {
                    LOG.debug("Done broadcasting a received websocket message to all nodes. Response: " + broadcastReceivedWebsocketMessageToResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOG.error("Failed to send a broadcast to websocket message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void forwardWebsocketMessageToConnectedServers(String sendFromOpenSearchNode, BroadcastToWebsocketMessage websocketMessage) {
        LOG.debug("forwardWebsocketMessageToConnectedServer sendFromOpenSearchNode=" + sendFromOpenSearchNode + ", websocketMessage=" + websocketMessage);
        PlainTextWebsocketMessage websocketMessageToSend = new PlainTextWebsocketMessage(websocketMessage.getMessage());
        this.connections.sendWebsocketMessageToServerUUIDs((WebsocketMessage)websocketMessageToSend, websocketMessage.getReceivers());
    }
}

