/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.WebSocketEndpointConfigurator;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllExceptSenderWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerLoadedModulesWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerStateInfoWebsocketMessage;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.common.logging.Loggers;

@ServerEndpoint(value="/_bpc", configurator=WebSocketEndpointConfigurator.class)
public class WebSocket {
    private static final Logger LOG = Loggers.getLogger(WebSocket.class, (String[])new String[]{"os-bpc-plugin"});
    private Session session;
    private final Manager manager;

    public WebSocket(Manager manager) {
        this.manager = manager;
    }

    @OnOpen
    public void onOpen(Session session) {
        LOG.info("onOpen " + session.getId());
        this.session = session;
        this.manager.registerWebSocket(this);
    }

    @OnClose
    public void onClose(CloseReason reason) {
        LOG.info("onClose " + reason);
        this.manager.unregisterWebSocket(this.getId());
        this.session = null;
    }

    @OnError
    public void onError(Throwable t) {
        LOG.error("onError " + (this.session == null ? null : this.session.getId()), t);
    }

    @OnMessage
    public void onMessage(String message) {
        LOG.debug("onMessage " + message);
        if (message == null || message.trim().length() <= 0) {
            return;
        }
        String websocketId = this.getId();
        if (ServerStateInfoWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                ServerStateInfoWebsocketMessage serverStateInfoWebsocketMessage = ServerStateInfoWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedServerStateInfoWebsocketMessage(websocketId, serverStateInfoWebsocketMessage);
            }
            catch (Exception ex) {
                LOG.error("Failed to process a received '" + ServerStateInfoWebsocketMessage.class.getSimpleName() + "' websocket message.", (Throwable)ex);
            }
            return;
        }
        if (ServerLoadedModulesWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                ServerLoadedModulesWebsocketMessage serverLoadedModulesWebsocketMessage = ServerLoadedModulesWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedServerLoadedModulesWebsocketMessage(websocketId, serverLoadedModulesWebsocketMessage);
            }
            catch (Exception ex) {
                LOG.error("Failed to process a received '" + ServerLoadedModulesWebsocketMessage.class.getSimpleName() + "' websocket message.", (Throwable)ex);
            }
            return;
        }
        if (BroadcastToAllWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage = BroadcastToAllWebsocketMessage.createFromMessage((String)message);
                String serverUUID = this.manager.getConnections().getServerUUIDForWebsocketId(websocketId);
                this.manager.processReceivedBroadcastToAllWebsocketMessage(websocketId, serverUUID, broadcastToAllWebsocketMessage);
            }
            catch (Exception ex) {
                LOG.error("Failed to process a received '" + BroadcastToAllWebsocketMessage.class.getSimpleName() + "' websocket message.", (Throwable)ex);
            }
            return;
        }
        if (BroadcastToAllExceptSenderWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                BroadcastToAllExceptSenderWebsocketMessage broadcastToAllExceptSenderWebsocketMessage = BroadcastToAllExceptSenderWebsocketMessage.createFromMessage((String)message);
                String serverUUID = this.manager.getConnections().getServerUUIDForWebsocketId(websocketId);
                this.manager.processReceivedBroadcastToAllExceptSenderWebsocketMessage(websocketId, serverUUID, broadcastToAllExceptSenderWebsocketMessage);
            }
            catch (Exception ex) {
                LOG.error("Failed to process a received '" + BroadcastToAllExceptSenderWebsocketMessage.class.getSimpleName() + "' websocket message.", (Throwable)ex);
            }
            return;
        }
        if (BroadcastToWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                BroadcastToWebsocketMessage broadcastToWebsocketMessage = BroadcastToWebsocketMessage.createFromMessage((String)message);
                String serverUUID = this.manager.getConnections().getServerUUIDForWebsocketId(websocketId);
                this.manager.processReceivedBroadcastToWebsocketMessage(websocketId, serverUUID, broadcastToWebsocketMessage);
            }
            catch (Exception ex) {
                LOG.error("Failed to process a received '" + BroadcastToWebsocketMessage.class.getSimpleName() + "' websocket message.", (Throwable)ex);
            }
            return;
        }
        try {
            BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage = new BroadcastToAllWebsocketMessage(message);
            String serverUUID = this.manager.getConnections().getServerUUIDForWebsocketId(websocketId);
            this.manager.processReceivedBroadcastToAllWebsocketMessage(websocketId, serverUUID, broadcastToAllWebsocketMessage);
        }
        catch (Exception ex) {
            LOG.error("Failed to process a received kind of '" + BroadcastToAllWebsocketMessage.class.getSimpleName() + "' websocket message.", (Throwable)ex);
        }
    }

    public String getId() {
        return this.session == null ? null : this.session.getId();
    }

    public void sendMessageAsync(WebsocketMessage websocketMessage, final ActionListener<Boolean> onComplete) {
        if (websocketMessage == null) {
            onComplete.onFailure(new Exception("A WebsocketMessage object must be given."));
        } else {
            try {
                String message = websocketMessage.getMessageToSend();
                if (StringUtil.isNullOrEmpty((String)message)) {
                    onComplete.onFailure(new Exception("Websocket message to send is null or empty."));
                } else if (this.session == null) {
                    onComplete.onFailure(new Exception("Websocket session is missing."));
                } else {
                    this.session.getAsyncRemote().sendText(message, new SendHandler(){

                        public void onResult(SendResult result) {
                            if (result != null && !result.isOK()) {
                                Throwable t = result.getException();
                                onComplete.onFailure(new Exception("Sending websocket message asynchronously failed.", t));
                            } else {
                                onComplete.onResponse((Object)Boolean.TRUE);
                            }
                        }
                    });
                }
            }
            catch (WebsocketMessageException ex) {
                onComplete.onFailure((Exception)((Object)ex));
            }
        }
    }
}

