/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.rest.action;

import de.virtimo.bpc.opensearch.plugin.BpcPlugin;
import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTOInstantiationException;
import de.virtimo.bpc.opensearch.plugin.rest.action.RequestBodyMissingException;
import de.virtimo.bpc.opensearch.plugin.rest.action.RequestParamMissingException;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;

public abstract class BaseBpcPluginRestHandler
extends BaseRestHandler {
    private static final Logger LOG = Loggers.getLogger(BaseBpcPluginRestHandler.class, (String[])new String[]{"os-bpc-plugin"});

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient);
        try {
            Manager manager = BpcPlugin.getInstance().getManager();
            return this.prepareRequest(request, nodeClient, manager);
        }
        catch (Exception ex) {
            return channel -> this.sendError((RestChannel)channel, ex);
        }
    }

    protected abstract BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest var1, NodeClient var2, Manager var3) throws IOException, RequestBodyMissingException, RequestParamMissingException, OpenSearchPluginDTOInstantiationException;

    protected String getMandatoryQueryParamAsString(RestRequest request, String paramName) throws RequestParamMissingException {
        String paramValue = request.param(paramName, null);
        if (paramValue == null || paramValue.length() == 0) {
            throw new RequestParamMissingException(paramName);
        }
        return paramValue;
    }

    protected String getMandatoryBodyAsString(RestRequest request) throws RequestBodyMissingException {
        if (request == null || !request.hasContent()) {
            throw new RequestBodyMissingException("The content in the request body is missing.");
        }
        return request.content().utf8ToString();
    }

    protected Map<String, Object> getMandatoryJsonBodyAsMap(RestRequest request) throws RequestBodyMissingException {
        Map map;
        if (request == null || !request.hasContent()) {
            throw new RequestBodyMissingException("The content in the request body is missing.");
        }
        try {
            map = JsonUtil.asMap((String)request.content().utf8ToString());
            if (map == null) {
                throw new RequestBodyMissingException("The content in the request body is empty.");
            }
        }
        catch (IOException ex) {
            throw new RequestBodyMissingException("The content in the request body is not a valid JSON.");
        }
        return map;
    }

    protected void sendOK(RestChannel channel) {
        LOG.debug("sendOK channel=...");
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "OK"));
    }

    protected void sendOK(RestChannel channel, String message) {
        LOG.debug("sendOK channel=..., message=" + message);
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, message));
    }

    protected void sendDTO(RestChannel channel, OpenSearchPluginDTO dto) {
        LOG.debug("sendDTO channel=..., dto=...");
        try (XContentBuilder builder = channel.newBuilder();){
            dto.toXContent(builder, null);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
        }
        catch (IOException ex) {
            this.sendError(channel, ex);
        }
    }

    protected void sendNotFound(RestChannel channel, String message) {
        LOG.debug("sendNotFound channel=..., message=" + message);
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_FOUND, message));
    }

    protected void sendBadRequest(RestChannel channel, String message) {
        LOG.debug("sendBadRequest channel=..., message=" + message);
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, message));
    }

    protected void sendError(RestChannel channel, Exception ex) {
        LOG.debug("sendError channel=..., ex=...");
        if (ex instanceof RequestParamMissingException) {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, ex.getMessage()));
        } else if (ex instanceof RequestBodyMissingException) {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, ex.getMessage()));
        } else {
            LOG.error("Unexpected error occurred.", (Throwable)ex);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ex.getMessage()));
        }
    }
}

